/*xxx
* \brief - sci_mix, sci_mix_x test application
* \author maki
*/

// ----MSVC----
#include <iostream>
#include <fstream>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ---- SIM  ----
#include "sim\_sim_extension.hpp"

// ----- SCI -----
#include "sci\_sci_macros.hpp"
#include "sci\_sci_exception.hpp"
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SCI;

//! Mix exp(j*p) * exp(-jp)
int tf_sci_mix_x()
{

#ifdef _SCI_
  sci_base *p_wgn1, *p_wgn_x1, *p_mix1, *p_mix_x1;  
#else
  void     *p_wgn1, *p_wgn_x1, *p_mix1, *p_mix_x1;
#endif

  const int N = 10;
  bvec ce;
  vec  x1, x2, y1, y1_ref;
  mat  x;
  cvec x_x1, x_x2, y_x1, y_x1_ref;
  cmat x_x;
  int err = 0;
  int sci_type;

  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_mix_x" << endl;
  try
  {

    p_wgn1 = SCI_CREATE(SCI_WGN);
    p_wgn_x1 = SCI_CREATE(SCI_WGN_X);

    p_mix1 = SCI_CREATE(SCI_MIX);
    sci_type = SCI_GET<int>(p_mix1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_MIX, "mix1.sci_type != SCI_MIX");

    p_mix_x1 = SCI_CREATE(SCI_MIX_X);
    sci_type = SCI_GET<int>(p_mix_x1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_MIX_X, "mix_x1.sci_type != SCI_MIX_X");

    debug(1) << "Number of samples N = " << N << endl;

    ce.set_length(N);
    ce.ones();

    x1 = SCI_GEN<vec>(p_wgn1, ce);
    x2 = SCI_GEN<vec>(p_wgn1, ce);
    x.set_size(N, 2);
    x.set_col(0, x1);
    x.set_col(1, x2);

    x_x1 = SCI_GEN<cvec>(p_wgn_x1, ce);
    x_x2 = SCI_GEN<cvec>(p_wgn_x1, ce);
    x_x.set_size(N, 2);
    x_x.set_col(0, x_x1);
    x_x.set_col(1, x_x2);

    y1 = SCI_PROC<vec>(p_mix1, ce, x);
    y1_ref = itpp::elem_mult(x1, x2);

    debug(3) << "    x1 =" << x1 << endl;
    debug(3) << "    x2 =" << x2 << endl;
    debug(3) << "    y1 = " << y1 << endl;
    debug(3) << "y1_ref = " << y1_ref << endl;

    y_x1 = SCI_PROC<cvec>(p_mix_x1, ce, x_x);
    y_x1_ref = itpp::elem_mult(x_x1, x_x2);

    debug(3) << "    x_x1 =" << x_x1 << endl;
    debug(3) << "    x_x2 =" << x_x2 << endl;
    debug(3) << "    y_x1 = " << y_x1 << endl;
    debug(3) << "y_x1_ref = " << y_x1_ref << endl;

    itpp_sci_assert(y1 == y1_ref, "y1 != y1_ref");
    itpp_sci_assert(y_x1 == y_x1_ref, "y_x1 != y_x1_ref");

    SCI_DESTROY(p_wgn1);
    SCI_DESTROY(p_wgn_x1);
    SCI_DESTROY(p_mix1);
    SCI_DESTROY(p_mix_x1);

  }
  catch (itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch (sci_exception &except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch (...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}
