/*xxx
* \brief - sci_nco, sci_vco test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <fstream>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ---- SIM  ----
#include "sim\_sim_extension.hpp"

// ----- SCI -----
#include "sci\_sci_macros.hpp"
#include "sci\_sci_exception.hpp"
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SCI;

//! compare nco and vco outputs for given phase step
int tf_sci_nco()
{
#ifdef _SCI_
  sci_base *p_nco1, *p_vco1;
#else
  void *p_nco1, *p_vco1;
#endif

  // input is L/M  checked for cases 1/8; 2/9; -1/8; -2/9;
  // 1/8 is an easy test; 
  // 2/9 more complicated case - nco fails for L/M exactly 2/9  
  // the ideal sequence looks like this below - vco produces a sequence with cy jitter 
  //  [0][-2 / 9], [0][-4 / 9], [0][-6 / 9], [0][-8 / 9], [-1][-1 / 9],
  //  [0][-3 / 9], [0][-5 / 9], [0][-7 / 9], [-1][0 / 9],
  //  [0][-2 / 9], [0][-4 / 9], [0][-6 / 9], [0][-8 / 9], [-1][-1 / 9],
  //  [0][-3 / 9], [0][-5 / 9], [0][-7 / 9], [-1][0 / 9],
  // in nco - double fractional input x[i] is rounded during conversion to fixed point Q1.N and this might be a reason (or not?)...

  const double L = -2.000001;
  const double M = 9.0;
  const int    N = 3 * (int)M;
  const int    Nq_bits = 60; // NCO phase accumulator format is Q1.Nq_bits

  bvec ce, true_vec;;
  vec  x;
  mat nco_y, vco_y;
  bvec nco_cy, vco_cy;
  vec nco_ph, vco_ph;
  mat all;
  double epsilon = 1.0E-6;
  int err = 0;
  int sci_type;

  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_nco" << endl;
  try
  {
    cout << fixed << setw(15) << setprecision(14) << endl;
    debug(1) << "epsilon =" << epsilon << endl;

    p_nco1 = SCI_CREATE(SCI_NCO);
    sci_type = SCI_GET<int>(p_nco1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_NCO, "sci_type != SCI_NCO");
    SCI_SET(p_nco1, SCI_PARAM_N, Nq_bits);
    debug(1) << "nco1.get_N() =" << SCI_GET<int>(p_nco1, SCI_PARAM_N) << endl;
    itpp_sci_assert(SCI_GET<int>(p_nco1, SCI_PARAM_N) == Nq_bits, "nco1.get_N() != Nq_bits");

    p_vco1 = SCI_CREATE(SCI_VCO);
    sci_type = SCI_GET<int>(p_vco1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_VCO, "sci_type != SCI_VCO");

    ce.set_length(N);
    ce.ones();
    true_vec.set_length(N);
    true_vec.ones();

    x.set_length(N);
    x.ones();
    x = (L / M) * x;
    debug(1) << "L/M =" << L << "/" << M << endl;

    nco_y = SCI_PROC<mat>(p_nco1, ce, x);
    vco_y = SCI_PROC<mat>(p_vco1, ce, x);

    nco_cy = (nco_y.get_col(0) != zeros(N));
    vco_cy = (vco_y.get_col(0) != zeros(N));

    nco_ph = nco_y.get_col(1);
    vco_ph = vco_y.get_col(1);


    all.set_size(N, 4);
    all.set_col(0, nco_y.get_col(0));
    all.set_col(1, nco_y.get_col(1));
    all.set_col(2, vco_y.get_col(0));
    all.set_col(3, vco_y.get_col(1));

    debug(1) << "[nco1[cy|ph]|vco1[cy|ph]] = " << endl << all << endl;
    itpp_sci_assert(nco_cy == vco_cy, "nco_cy != vco_cy ");
    itpp_sci_assert((abs(nco_ph - vco_ph) < epsilon) == true_vec, "abs(nco.ph - vco.ph) > epsilon ");

    SCI_DESTROY(p_nco1);
    SCI_DESTROY(p_vco1);

  }
  catch (itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch (sci_exception &except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch (...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}
