/*!
* \brief - sci_pam_mod, sci_pam_dem test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ---- SIM  ----
#include "sim\_sim_extension.hpp"

// ----- SCI -----
#include "sci\_sci_macros.hpp"
#include "sci\_sci_exception.hpp"
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SCI;

int tf_sci_pam()
{

#ifdef _SCI_
  sci_base *p_mod1, *p_dem1;
#else
  void *p_mod1, *p_dem1;
#endif

  const int M = 8;
  const vec v_ref = vec("-0.8750000, -0.6250000, -0.3750000, -0.1250000, 0.1250000, 0.3750000, 0.6250000, 0.8750000");

  bvec ce, true_vec;
  vec v;
  ivec ivx, ivy;

  double epsilon = 1.0E-6;
  int sci_type;
  int err = 0;

  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_pam" << endl;
  try
  {
    cout << fixed << setw(10) << setprecision(8);

    ivx = to_ivec(linspace(0, M - 1, M)); // [0,1,2...]
    ce = ones_b(M);
    true_vec = ones_b(M);

    p_mod1 = SCI_CREATE(SCI_PAM_MOD);
    sci_type = SCI_GET<int>(p_mod1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_PAM_MOD, "sci_type != SCI_PAM_MOD");

    p_dem1 = SCI_CREATE(SCI_PAM_DEM);
    sci_type = SCI_GET<int>(p_dem1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_PAM_DEM, "sci_type != SCI_PAM_DEM");

    SCI_SET(p_mod1, SCI_SIZE, M);
    debug(1) << "SCI::p_mod1 size=" << SCI_GET<int>(p_mod1, SCI_SIZE) << endl;
    itpp_sci_assert(SCI_GET<int>(p_mod1, SCI_SIZE) == M, "pam_mod1.get_size() != M");

    SCI_SET(p_dem1, SCI_SIZE, M);
    debug(1) << "SCI::p_dem1 size=" << SCI_GET<int>(p_dem1, SCI_SIZE) << endl;
    itpp_sci_assert(SCI_GET<int>(p_dem1, SCI_SIZE) == M, "pam_dem1.get_size() != M");

    v = SCI_PROC<vec>(p_mod1, ce, ivx);
    ivy = SCI_PROC<ivec>(p_dem1, ce, v);

    debug(1) << "ivx = " << ivx << endl;
    debug(1) << "  v = " << v << endl;
    debug(1) << "ivy = " << ivy << endl;

    itpp_sci_assert(ivy == ivx, "ivy ! =ivx");
    itpp_sci_assert((abs(v - v_ref) < epsilon) == true_vec, "v ! = v_ref");

    SCI_DESTROY(p_mod1);
    SCI_DESTROY(p_dem1);
  }
  catch(sci_exception except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
  }
  return 0;
}
