/*!
* \brief - sci_psk_mod, sci_psk_dem test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ---- SIM  ----
#include "sim\_sim_extension.hpp"

// ----- SCI -----
#include "sci\_sci_macros.hpp"
#include "sci\_sci_exception.hpp"
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SCI;

int tf_sci_psk()
{

#ifdef _SCI_
  sci_base *p_mod1, *p_dem1;
#else
  void *p_mod1, *p_dem1;
#endif

  const  int  M = 8;      // Symbol size 8PSK
  bvec ce, true_vec;
  cvec cv, cv_ref;
  ivec ivx, ivy, ivy_ref;

  double epsilon = 1.0E-6;
  int sci_type;
  int err = 0;

  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_psk" << endl;
  try
  {
    cout << fixed << setw(5) << setprecision(2);

    ivx = to_ivec(linspace(0, M - 1, M));        // [0,1,2...]
    cv_ref = cvec("0.7071068+0.0000000i, 0.5000000+0.5000000i, 0.0000000+0.7071068i, -0.5000000+0.5000000i, -0.7071068+0.0000000i, -0.5000000-0.5000000i, 0.0000000-0.7071068i, 0.5000000-0.5000000i");
    ce = ones_b(M);
    true_vec = ones_b(M);

    p_mod1 = SCI_CREATE(SCI_PSK_MOD);
    sci_type = SCI_GET<int>(p_mod1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_PSK_MOD, "sci_type != SCI_PSK_MOD");

    p_dem1 = SCI_CREATE(SCI_PSK_DEM);
    sci_type = SCI_GET<int>(p_dem1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_PSK_DEM, "sci_type != SCI_PSK_DEM");

    SCI_SET(p_mod1, SCI_SIZE, M);
    debug(1) << "SCI::p_mod1 size=" << SCI_GET<int>(p_mod1, SCI_SIZE) << endl;
    itpp_sci_assert(SCI_GET<int>(p_mod1, SCI_SIZE) == M, "psk_mod1.get_size() != M");

    SCI_SET(p_dem1, SCI_SIZE, M);
    debug(1) << "SCI::p_dem1 size=" << SCI_GET<int>(p_dem1, SCI_SIZE) << endl;
    itpp_sci_assert(SCI_GET<int>(p_dem1, SCI_SIZE) == M, "psk_dem1.get_size() != M");

    cv =  SCI_PROC<cvec>(p_mod1, ce, ivx);
    ivy = SCI_PROC<ivec>(p_dem1, ce, cv);
    
    debug(1) << "    ivx = " << ivx << endl;
    debug(1) << "     cv = " << cv << endl;
    debug(1) << "    ivy = " << ivx << endl;

    itpp_sci_assert(ivy == ivx, "ivy ! =ivx");
    itpp_sci_assert((abs(cv - cv_ref) < epsilon) == true_vec, "cv ! =cv_ref");

    SCI_DESTROY(p_mod1);
    SCI_DESTROY(p_dem1);
  }
  catch (itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch (sci_exception &except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch (...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}
