/*!
* \brief sci_qam_mod, sci_qam_dem test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>

// ---- ITPP  ----

// ----- SCI -----
#include "sci\_sci_macros.hpp"
#include "sci\_sci_exception.hpp"
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SCI;

int tf_sci_qam()
{

#ifdef _SCI_
  sci_base *p_qmod1, *p_qdem1;
#else
  void *p_qmod1, *p_qdem1;
#endif

  int M, m;
  bvec ce ;
  cvec cv, cv_ref;
  ivec ivx, ivy, ivy_ref;
  int err = 0;
  int sci_type;

  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_qam" << endl;
  try
  {
    // Test constelation is QPSK
    M = 4;
    p_qmod1 = SCI_CREATE(SCI_QAM_MOD);
    sci_type = SCI_GET<int>(p_qmod1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_QAM_MOD, "sci_type != SCI_QAM_MOD");

    p_qdem1 = SCI_CREATE(SCI_QAM_DEM);
    sci_type = SCI_GET<int>(p_qdem1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_QAM_DEM, "sci_type != SCI_QAM_DEM");

    SCI_SET(p_qmod1, SCI_SIZE, M);
    m = SCI_GET<int>(p_qmod1, SCI_SIZE);
    cout << "SCI::p_qmod1 size=" << m << endl;
    itpp_sci_assert(m == M, "m != M");

    SCI_SET(p_qdem1, SCI_SIZE, M);
    m = SCI_GET<int>(p_qdem1, SCI_SIZE);
    cout << "SCI::p_qdem1 size=" << m << endl;
    itpp_sci_assert(m == M, "m != M");

    cv.set_length(M);
    ivx.set_length(M);
    ivy.set_length(M);
    ivx = ivec("0, 1, 2, 3");
    cv_ref = cvec("0.50000+0.50000i, -0.50000+0.50000i, 0.50000-0.50000i, -0.50000-0.50000i");
    ivy_ref = ivx;

    ce = ones_b(M);
    cv =  SCI_PROC<cvec>(p_qmod1, ce, ivx);
    ivy = SCI_PROC<ivec>(p_qdem1, ce, cv);

    debug(1) << "    ivx = " << ivx << endl;
    debug(1) << "     cv = " << cv << endl;
    debug(1) << " cv_ref = " << cv_ref << endl;
    debug(1) << "    ivy = " << ivx << endl;
    debug(1) << "ivy_ref = " << ivx << endl;
    itpp_sci_assert(cv == cv_ref, "cv!=cv_ref");
    itpp_sci_assert(ivy == ivy_ref, "ivy!=ivy_ref");

    SCI_DESTROY(p_qmod1);
    SCI_DESTROY(p_qdem1);
  }
  catch(itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch(sci_exception &except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch(...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}
