/*!
* \brief sci_rms, sci_rms_x test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>

// ---- ITPP  ----

// ----- SCI -----
#include "sci\_sci_macros.hpp"
#include "sci\_sci_exception.hpp"
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SCI;

int tf_sci_rms()
{

#ifdef _SCI_
  sci_base *p_rms1, *p_rms_x1;
#else
  void *p_rms1, *p_rms_x1;
#endif

  const int MAV = 10;   // mav lenght
  const int N = 20;     // sequence lenght
  bvec ce, true_vec;
  vec x1;
  cvec x_x1;
  vec y1, y1_ref;
  vec y_x1, y_x1_ref;
  double epsilon = 1.0E-5;
  int err = 0;
  int sci_type;

  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_rms" << endl;
  try
  {

    p_rms1 = SCI_CREATE(SCI_RMS);
    sci_type = SCI_GET<int>(p_rms1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_RMS, "sci_type != SCI_RMS");

    p_rms_x1 = SCI_CREATE(SCI_RMS_X);
    sci_type = SCI_GET<int>(p_rms_x1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_RMS_X, "sci_type != SCI_RMS_X");

    ce.set_length(N);
    ce.ones();
    true_vec.set_length(N);
    true_vec.ones();
    x1.set_length(N);
    x1.ones();
    x_x1 = to_cvec(x1, x1); // (1.0+j1.0)
    debug(1) << "epsilon =" << epsilon << endl;
    debug(1) << "    ce =" << ce << endl;

    SCI_SET(p_rms1, SCI_SIZE, MAV);
    itpp_sci_assert(SCI_GET<int>(p_rms1, SCI_SIZE) == MAV, "rms1.size !=MAV");
    SCI_SET(p_rms_x1, SCI_SIZE, MAV);
    itpp_sci_assert(SCI_GET<int>(p_rms_x1, SCI_SIZE) == MAV, "rms_x1.size !=MAV");

    //       sqrt(MAV 1.0 step response)
    //       sqrt(0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.0 1.0......)
    y1_ref = vec("0.31623 0.44721 0.54772 0.63246 0.70711 0.77460 0.83666 0.89443 0.94868 1.00000 1.00000 1.00000 1.00000 1.00000 1.00000 1.00000 1.00000 1.00000 1.00000 1.00000");
    y1 = SCI_PROC<vec>(p_rms1, ce, x1);
    debug(1) << "    x1 =" << x1 << endl;
    debug(1) << "    y1 = " << y1 << endl;
    debug(1) << "y1_ref = " << y1_ref << endl;
    debug(1) << "(abs(y1 - y1_ref) < epsilon) = \n" << (abs(y1 - y1_ref) < epsilon) << endl;
    itpp_sci_assert((abs(y1 - y1_ref) < epsilon) == true_vec, "abs(y1 - y1_ref) > epsilon ");

    //   sqrt(MAV sqrt(2) step response)
    //   sqrt(2)*sqrt(0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.0 1.0......)
    y_x1_ref = vec("0.44721 0.63246 0.77460 0.89443 1.00000 1.09545 1.18322 1.26491 1.34164 1.41421 1.41421 1.41421 1.41421 1.41421 1.41421 1.41421 1.41421 1.41421 1.41421 1.41421");
    debug(1) << "      ce =" << ce << endl;
    debug(1) << "    x_x1 = " << x_x1 << endl;
    y_x1 = SCI_PROC<vec>(p_rms_x1, ce, x_x1);
    debug(1) << "    y_x1 = " << y_x1 << endl;
    debug(1) << "y_x1_ref = " << y_x1_ref << endl;
    debug(1) << "(abs(y_x1 - y1_x1_ref) < epsilon) = \n" << (abs(y_x1 - y_x1_ref) < epsilon) << endl;
    itpp_sci_assert((abs(y_x1 - y_x1_ref) < epsilon) == true_vec, "abs(y_x1 - y_x1_ref) > epsilon ");

    SCI_DESTROY(p_rms1);
    SCI_DESTROY(p_rms_x1);
  }
  catch(itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch(sci_exception &except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch(...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}
