/*!
* \brief - sci_tedg_x test application 
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ---- SIM  ----
#include "sim\_sim_extension.hpp"

// ----- SCI -----
#include "sci\_sci_macros.hpp"
#include "sci\_sci_exception.hpp"
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SCI;

int tf_sci_tedg_x()
{

#ifdef _SCI_
  sci_base  *p_tedg_x1;
#else
  void      *p_tedg_x1;
#endif

  bvec true_vec;
  bmat ceio;
  vec  x;
  cvec x_x;
  cvec y_x, y_x_ref;

  const double epsilon = 1.0E-6;
  int sci_type;
  int err = 0;

  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_tedg_x" << endl;
  try
  {
    true_vec = ones_b(3);

    cout << fixed << setw(6) << setprecision(6);

    p_tedg_x1 = SCI_CREATE(SCI_TEDG_X);
    sci_type = SCI_GET<int>(p_tedg_x1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_TEDG_X, "sci_type != SCI_TEDG_X");

    SCI_SET(p_tedg_x1, SCI_MODE, (int)TEDG_MODE_STD);
    itpp_sci_assert(SCI_GET<int>(p_tedg_x1, SCI_MODE) == TEDG_MODE_STD, "mode != TEDG_MODE_STD");

    // ceio[cei|ceo]
    ceio = bmat("1 1; 1 0; 1 1");
    // perfect timing for triangle waveform
    x = vec("1.0 0.0 -1.0");
    x_x = to_cvec(x, x);
    y_x_ref = cvec("0.000+0.000i, 0.000+0.000i, 0.000+0.000i");
    y_x = SCI_PROC<cvec>(p_tedg_x1, ceio, x_x);
    debug(1) << "y_x = " << endl << y_x << endl;
    itpp_sci_assert((abs(y_x - y_x_ref) < epsilon) == true_vec, "y_x != y_x_ref");

    // late timing for triangle waveform
    x = vec("0.5 -0.5 -0.5");
    x_x = to_cvec(x, x);
    y_x_ref = cvec("-0.500-0.500i, -0.500-0.500i, 0.500+0.500i");
    y_x = SCI_PROC<cvec>(p_tedg_x1, ceio, x_x);
    debug(1) << "y_x = " << endl << y_x << endl;
    itpp_sci_assert((abs(y_x - y_x_ref) < epsilon) == true_vec, "y_x != y_x_ref");

    // early timing for triangle waveform
    x = vec("0.5 0.5 -0.5");
    x_x = to_cvec(x, x);
    y_x_ref = cvec("-0.500-0.500i, -0.500-0.500i, -0.500-0.500i");
    y_x = SCI_PROC<cvec>(p_tedg_x1, ceio, x_x);
    debug(1) << "y_x = " << endl << y_x << endl;
    itpp_sci_assert((abs(y_x - y_x_ref) < epsilon) == true_vec, "y_x != y_x_ref");

  }
  catch (itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch (sci_exception &except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch (...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}
