/*!
* \brief sci_wgn, sci_wgn_x test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>

// ---- ITPP  ----
#include <itpp/stat/misc_stat.h>

// ----- SIM -----
#include "sim\_sim_extension.hpp"

// ----- SCI -----
#include "sci\_sci_exception.hpp"
#include "sci\_sci_macros.hpp"
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SCI;

// scilab emulated code
int tf_sci_wgn()
{

#ifdef _SCI_
  sci_base *p_wgn1, *p_wgn_x1;
#else
  void *p_wgn1, *p_wgn_x1;
#endif

  const int N = 1000;      // sequence lenght

  bvec ce;

  vec x1;
  double sigma_x1;
  double mean_x1;
  double sigma_x1_ref = 0.1;
  double mean_x1_ref = 0.2;

  cvec x_x1;
  double sigma_x_x1;
  complexd mean_x_x1;
  double sigma_x_x1_ref = 0.15;
  complexd mean_x_x1_ref = complexd(0.25, -0.25);

  double epsilon = 3.0E-1; // 30 %
  int err = 0;
  int sci_type;

  cout << "*** TEST *** " << SCI_NAMESPACE << "::sci_wgn" << endl;
  try
  {

    debug(1) << "epsilon = " << epsilon << endl;
    debug(1) << "Number of samples N = " << N << endl;

    ce.set_length(N);
    ce.ones();

    p_wgn1 = SCI_CREATE(SCI_WGN);
    sci_type = SCI_GET<int>(p_wgn1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_WGN, "sci_type != SCI_WGN");
    SCI_SET(p_wgn1, SCI_SIGMA, sigma_x1_ref);
    itpp_sci_assert(SCI_GET<double>(p_wgn1, SCI_SIGMA) == sigma_x1_ref, "wgn1.get_sigma() != sigma_x1_ref");
    SCI_SET(p_wgn1, SCI_MEAN, mean_x1_ref);
    debug(1) << "wgn1.get.mean() =" << SCI_GET<double>(p_wgn1, SCI_MEAN) << endl;
    debug(1) << "mean_x1_ref =" << mean_x1_ref << endl;
    itpp_sci_assert(SCI_GET<double>(p_wgn1, SCI_MEAN) == mean_x1_ref, "wgn1.get_mean() != mean_x1_ref");


    p_wgn_x1 = SCI_CREATE(SCI_WGN_X);
    sci_type = SCI_GET<int>(p_wgn_x1, SCI_TYPE);
    itpp_sci_assert(sci_type == SCI_WGN_X, "sci_type != SCI_WGN_X");
    SCI_SET(p_wgn_x1, SCI_SIGMA, sigma_x_x1_ref);
    itpp_sci_assert(SCI_GET<double>(p_wgn_x1, SCI_SIGMA) == sigma_x_x1_ref, "wgn_x1.get_sigma() != sigma_x1_ref");
    SCI_SET(p_wgn_x1, SCI_MEAN, mean_x_x1_ref);
    debug(1) << "wgn_x1.get.mean() =" << SCI_GET<complexd>(p_wgn_x1, SCI_MEAN) << endl;
    debug(1) << "mean_x_x1_ref =" << mean_x_x1_ref << endl;
    itpp_sci_assert(SCI_GET<complexd>(p_wgn_x1, SCI_MEAN) == mean_x_x1_ref, "wgn_x1.get_mean() != mean_x_x1_ref");


    x1 = SCI_GEN<vec>(p_wgn1, ce);
    mean_x1 = mean(x1);
    debug(1) << "mean(x1) =" << mean_x1 << endl;
    if(mean_x1_ref != 0.0)
    {
      itpp_sci_assert(abs((mean_x1 - mean_x1_ref) / mean_x1_ref) < epsilon, "abs((mean_x1 - mean_x1_ref) / mean_x1_ref) > epsilon");
    }
    // variance = E[(X-m)^2] = E[x^2] | X=x+m
    sigma_x1 = std::sqrt(variance<double>(x1));
    debug(1) << "sigma(x1) =" << sigma_x1 << endl;
    debug(1) << "sigma_x1_ref =" << sigma_x1_ref << endl;
    itpp_sci_assert((sigma_x1 - sigma_x1_ref) < epsilon * sigma_x1_ref, "(sigma_x1 - sigma_x1_ref)/sigma_x1_ref > epsilon*sigma_x1_ref");


    x_x1 = SCI_GEN<cvec>(p_wgn_x1, ce);
    mean_x_x1 = mean(x_x1);
    debug(1) << "mean(x_x1) =" << mean(x_x1) << endl;
    if(abs(mean_x_x1_ref) != 0.0)
    {
      itpp_sci_assert((abs(mean_x1) - abs(mean_x1_ref)) / abs(mean_x1_ref) < epsilon, "abs((abs(mean_x1) - abs(mean_x1_ref)) / abs(mean_x1_ref) > epsilon");
    }
    // variance = E[(X-m)*(conj(X)-conj(m))] = E[x*conj(x)]
    sigma_x_x1 = std::sqrt(variance(x_x1));
    debug(1) << "sigma(x_x1) =" << sigma_x_x1 << endl;
    debug(1) << "sigma(x_x1_ref) =" << sigma_x_x1_ref << endl;
    itpp_sci_assert((sigma_x_x1 - sigma_x_x1_ref) < epsilon * sigma_x_x1_ref, "(sigma_x_x1 - sigma_x_x1_ref)/sigma_x_x1_ref > epsilon*sigma_x1_ref");

    SCI_DESTROY(p_wgn1);
    SCI_DESTROY(p_wgn_x1);

  }
  catch(itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch(sci_exception &except)
  {
    cout << "\n sci exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch(...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}
