/*xxx
 * \brief -  SIM::amp, SIM::amp_x test application
 * compares output with the pre-calculated reference
 * \author maki
 */

// ---- MSVC  ----
#include <iostream>
#include <iomanip>
#include <complex>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ----- SIM -----
#include "sim\_sim_lib.hpp"
#include "sim\_sim_exception.hpp"

// ----- SCI -----
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SIM;


int tf_sim_amp_x()
{
  SIM::wgn		wgn1;
  SIM::wgn_x	wgn_x1;
  SIM::amp	  g1;
  SIM::amp_x	g_x1;

  const int N = 10;      // sequence lenght
  const double g1_gain = 1.1;
  const double g1_offset = 0.1;
  const complexd g_x1_gain = complexd(1.15, 1.25);
  const complexd g_x1_offset = complexd(0.15, 0.25);

  bvec ce;
  vec  x1, y1, y1_ref;
  cvec x_x1, y_x1, y_x1_ref;

  int err = 0;

  cout << "*** TEST SIM *** amp_x" << endl;
  try
  {

    debug(1) << "Number of samples N = " << N << endl;

    g1.set_gain(g1_gain);
    g1.set_offset(g1_offset);

    debug(1) << "g1.gain =" << g1.get_gain()  << endl;
    debug(1) << "g1.offset =" << g1.get_offset() << endl;

    itpp_sci_assert(g1.get_gain() == g1_gain, "g1.get_gain() != g1_gain");
    itpp_sci_assert(g1.get_offset() == g1_offset, "g1.get_offset() != g1_offset");

    g_x1.set_gain(g_x1_gain);
    g_x1.set_offset(g_x1_offset);

    debug(1) << "g_x1.gain =" << g_x1.get_gain() << endl;
    debug(1) << "g_x1.offset =" << g_x1.get_offset() << endl;

    itpp_sci_assert(g_x1.get_gain() == g_x1_gain, "g_x1.get_gain() != g_x1_gain");
    itpp_sci_assert(g_x1.get_offset() == g_x1_offset, "g_x1.get_offset() != g_x1_offset");

    ce.set_length(N);
    ce.ones();

    x1 = wgn1.generate(ce);
    x_x1 = wgn_x1.generate(ce);

    y1 = g1.process(ce, x1);
    y1_ref = g1_gain*x1 + g1_offset;

    debug(3) << "    x1 =" << x1 << endl;
    debug(3) << "    y1 = " << y1 << endl;
    debug(3) << "y1_ref = " << y1_ref << endl;

    y_x1 = g_x1.process(ce, x_x1);
    y_x1_ref = g_x1_gain*x_x1 + g_x1_offset;

    debug(3) << "    x_x1 =" << x_x1 << endl;
    debug(3) << "    y_x1 = " << y_x1 << endl;
    debug(3) << "y_x1_ref = " << y_x1_ref << endl;

    itpp_sci_assert(y1 == y1_ref, "y1 != y1_ref");
    itpp_sci_assert(y_x1 == y_x1_ref, "y_x1 != y_x1_ref");

  }
  catch (itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch (sim_exception &except)
  {
    cout << "\n sim_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch (...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}

