/*!
* \brief  sim_bert test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>

// ----- SIM -----
#include "sim\_sim_lib.hpp"
#include "sim\_sim_exception.hpp"

// ----- ITPP_SCI -----
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SIM;

int tf_sim_bert()
{
  SIM::bert bert1;
  SIM::lfsr prbs1;

  int N, W, L, PRBS, fsm;
  int k, K_RELOAD, K_PRESET, K;
  bvec one = bvec("1");
  bvec ce;
  ivec T;
  bmat p, pmat, errmat;
  bvec x, y, z, z1;
  bvec x_ref, y_ref, z_ref;
  ivec state;
  ivec cnt, acc_cnt;
  ivec cnt_ref, acc_cnt_ref;
  int err = 0;

  cout << "*** TEST SIM *** bert" << endl;

  // Symbol size QPSK
  W = 2;
  // test paterns by prbs generator M=2^PRBS-1
  PRBS = 4;
  // BERT correlator - number of symbols
  N = 10;
  // BERT correlator lenght
  L = W * N;
  // T= [T0, T1, T2] - SYNC for metrics < T1 i.e. BER < 4/20 (more than 1.0E-1);
  T = "2 4 8";

  try
  {
    // set LFSR as prbs generator
    prbs1.set_prbs(PRBS);
    debug(1) << "SIM::prbs1.set_prbs PRBS=" << PRBS << endl;
    prbs1.set_symbol_size(W);
    debug(1) << "SIM::prbs1.set_symbol_size W=" << W << endl;
    // set BERT prbs generator
    bert1.set_prbs(PRBS);
    debug(1) << "SIM::bert1.set_prbs PRBS=" << PRBS << endl;
    // L must be set first - symbol_size <= L
    bert1.set_length(L);
    debug(1) << "SIM::bert1.set_symbol_size L=" << L << endl;
    bert1.set_symbol_size(W);
    debug(1) << "SIM::bert1.set_symbol_size W=" << W << endl;
    bert1.set_threshold(T);
    debug(1) << "SIM::bert1.set_threshold T=" << T << endl;
    // set initiation state
    bert1.set_fsm(BERT_FSM_RELOAD);
    debug(1) << "SIM::bert1.set_FSM(BERT_FSM_RELOAD)" << endl;

    // number of symbols to transition from RELOAD->PRESET
    K_RELOAD = prbs1.get_length() / W ;
    debug(1) << "RELOAD->PRESET needs K_RELOAD = " << K_RELOAD << " symbols" << endl;
    for(k = 0; k < K_RELOAD; k++)
    {
      debug(2) << "[" << k << "]" << endl;
      p = prbs1.generate(one);
      debug(2) << " prbs =" << p << endl;
      state = bert1.process(one, p);
      bert1.set_adr(BERT_ADR_LSRX);
      x = bert1.get_state();
      bert1.set_adr(BERT_ADR_LSRY);
      y = bert1.get_state();
      bert1.set_adr(BERT_ADR_PRBS);
      z = bert1.get_state();
      fsm = bert1.get_fsm();
      z1 = prbs1.get_state();
      debug(2) << " x=" << x << endl;
      debug(2) << " y=" << y << endl;
      debug(2) << " z=" << z << endl;
      debug(2) << "z1=" << z1 << endl;
      debug(2) << " metrics=" << bert1.get_metrics() << endl;
      debug(2) << " state =" << fsm << endl;
      debug(2) << " fsm =" << fsm << endl;
    }

    x_ref = bvec("1 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0");
    debug(1) << "    x=" << x << endl;
    debug(1) << "x_ref=" << x_ref << endl;
    y_ref = bvec("0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0");
    debug(1) << "    y=" << y << endl;
    debug(1) << "y_ref=" << y_ref << endl;
    z_ref = bvec("0 0 1 1");
    debug(1) << "    z=" << z << endl;
    debug(1) << "z_ref=" << z_ref << endl;
    debug(1) << "  fsm=" << fsm << endl;

    itpp_sci_assert(x == x_ref, "x!=x_ref");
    itpp_sci_assert(y == y_ref, "y!=y_ref");
    itpp_sci_assert(z == z_ref, "z!=z_ref");
    itpp_sci_assert(fsm == BERT_FSM_PRESET, "fsm != BERT_FSM_PRESET");

    // number of symbols to transition from PRESET->SYNC
    K_PRESET = bert1.get_length() / W;
    debug(1) << "PRESET->SYNC needs K_PRESET = " << K_PRESET << " symbols" << endl;
    for(k = 0; k < K_PRESET; k++)
    {
      debug(2) << "[" << k << "]" << endl;
      p = prbs1.generate(one);
      debug(2) << " prbs =" << p << endl;
      state = bert1.process(one, p);
      bert1.set_adr(BERT_ADR_LSRX);
      x = bert1.get_state();
      bert1.set_adr(BERT_ADR_LSRY);
      y = bert1.get_state();
      bert1.set_adr(BERT_ADR_PRBS);
      z = bert1.get_state();
      z1 = prbs1.get_state();
      fsm = bert1.get_fsm();
      debug(2) << " x=" << x << endl;
      debug(2) << " y=" << y << endl;
      debug(2) << " z=" << z << endl;
      debug(2) << "z1=" << z1 << endl;
      debug(2) << " metrics=" << bert1.get_metrics() << endl;
      debug(2) << " fsm =" << fsm << endl;
    }
    x_ref = bvec("1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 0");
    debug(1) << "    x=" << x << endl;
    debug(1) << "x_ref=" << x_ref << endl;
    y_ref = bvec("1 1 0 1 0 1 1 0 0 1 0 0 0 1 1 1 1 0 1 0");
    debug(1) << "    y=" << y << endl;
    debug(1) << "y_ref=" << y_ref << endl;
    z_ref = bvec("1 0 1 1");
    debug(1) << "    z=" << z << endl;
    debug(1) << "z_ref=" << z_ref << endl;
    debug(1) << "  fsm=" << fsm << endl;
    itpp_sci_assert(x == x_ref, "x!=x_ref");
    itpp_sci_assert(y == y_ref, "y!=y_ref");
    itpp_sci_assert(z == z_ref, "z!=z_ref");
    itpp_sci_assert(fsm == BERT_FSM_SYNC, "fsm != BERT_FSM_SYNC");

    acc_cnt = bert1.get_acc_cnt();
    cnt = bert1.get_cnt();
    acc_cnt_ref = ivec("0 0");
    cnt_ref = ivec("0 0");
    debug(1) << "         cnt=" << cnt << endl;
    debug(1) << "     cnt_ref=" << cnt_ref << endl;
    debug(1) << "     acc_cnt=" << acc_cnt << endl;
    debug(1) << " acc_cnt_ref=" << acc_cnt_ref << endl;
    itpp_sci_assert(cnt == cnt_ref, "cnt != cnt_ref");
    itpp_sci_assert(acc_cnt == acc_cnt_ref, "acc_cnt != acc_cnt_ref");

    // test BER
    K = 10;
    debug(1) << "SYNC with no errors K = " << K << " symbols" << endl;
    ce = ones_b(K);
    pmat = prbs1.generate(ce); // must generate continously - this is what bert expects
    bert1.process(ce, pmat);
    acc_cnt = bert1.get_acc_cnt();
    cnt = bert1.get_cnt();
    fsm = bert1.get_fsm();
    acc_cnt_ref = ivec("0 20");
    cnt_ref = ivec("0 20");
    debug(1) << "         fsm=" << fsm << endl;
    debug(1) << "         cnt=" << cnt << endl;
    debug(1) << "     cnt_ref=" << cnt_ref << endl;
    debug(1) << "     acc_cnt=" << acc_cnt << endl;
    debug(1) << " acc_cnt_ref=" << acc_cnt_ref << endl;
    itpp_sci_assert(cnt == cnt_ref, "cnt != cnt_ref");
    itpp_sci_assert(acc_cnt == acc_cnt_ref, "acc_cnt != acc_cnt_ref");
    itpp_sci_assert(fsm == BERT_FSM_SYNC, "fsm != BERT_FSM_SYNC");

    // make one err
    debug(1) << "SYNC with 1 error K = " << K << " symbols" << endl;
    errmat = zeros_b(K, W);
    errmat(0, 0) = 1;
    pmat = prbs1.generate(ce);
    pmat = pmat + errmat;
    bert1.process(ce, pmat);

    cnt = bert1.get_cnt();
    acc_cnt = bert1.get_acc_cnt();

    acc_cnt_ref = ivec("1 40");
    cnt_ref = ivec("1 20");
    debug(1) << "        fsm=" << fsm << endl;
    debug(1) << "        cnt=" << cnt << endl;
    debug(1) << "    cnt_ref=" << cnt_ref << endl;
    debug(1) << "    acc_cnt=" << acc_cnt << endl;
    debug(1) << " acc_cntref=" << acc_cnt_ref << endl;
    itpp_sci_assert(cnt == cnt_ref, "cnt != cnt_ref");
    itpp_sci_assert(acc_cnt == acc_cnt_ref, "acc_cnt != acc_cnt_ref");
    itpp_sci_assert(fsm == BERT_FSM_SYNC, "fsm != BERT_FSM_SYNC");

  }
  catch(itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch(sim_exception &except)
  {
    cout << "\n sim_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch(...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;

}

