/*!
* \brief - bin2int, int2bin test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ----- SIM -----
#include "sim\_sim_lib.hpp"
#include "sim\_sim_exception.hpp"

// ----- SCI -----
#include "_sci_assert.hpp"
#include "__debug_level.h"
#include "debug.hpp"


using namespace std;
using namespace itpp;
using namespace SIM;


int tf_sim_bin2int()
{
  SIM::bin2int b2i1;
  SIM::int2bin i2b1;

  const int N = 16;
  const int W = 4;
  int i;
  bvec ce;
  bmat y1, y1_ref;
  ivec x1, y2;
  int err = 0;

  cout << "*** TEST SIM *** bin2int"  << endl;
  try
  {
    ce.set_length(N);
    ce.ones();
    debug(1) << "ce =" << ce << endl;

    x1.set_length(N);
    for(i = 0; i < N; i++)
    {
      x1[i] = i;
    }
    debug(1) << "x =" << x1 << endl;

    i2b1.set_symbol_size(W);
    itpp_sci_assert(W == i2b1.get_symbol_size(), "W != i2b1.get_symbol_size()");

    b2i1.set_symbol_size(W);
    itpp_sci_assert(W == b2i1.get_symbol_size(), "W != b2i1.get_symbol_size()");

    y1_ref = bmat("0 0 0 0; 0 0 0 1; 0 0 1 0; 0 0 1 1; 0 1 0 0; 0 1 0 1; 0 1 1 0; 0 1 1 1;\
                   1 0 0 0; 1 0 0 1; 1 0 1 0; 1 0 1 1; 1 1 0 0; 1 1 0 1; 1 1 1 0; 1 1 1 1");

    y1 = i2b1.process(ce, x1);
    debug(1) << "y1 = \n" << y1 << endl;
    itpp_sci_assert(y1 == y1_ref, "y1 != y1_ref");

    y2 = b2i1.process(ce, y1);
    debug(1) << "y2 =" << y2 << endl;
    itpp_sci_assert(y2 == x1, "y2 != x1");

    i2b1.set_msb_flag(0);
    b2i1.set_msb_flag(0);
    for(i = 0; i < N; i++)
    {
      y1_ref.set_row(i, reverse(y1_ref.get_row(i)));
    }

    y1 = i2b1.process(ce, x1);
    debug(1) << "y1 = \n" << y1 << endl;
    itpp_sci_assert(y1 == y1_ref, "y1 != y1_ref");

    y2 = b2i1.process(ce, y1);
    debug(1) << "y2 =" << y2 << endl;
    itpp_sci_assert(y2 == x1, "y2 != x1");

  }
  catch(itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch(sim_exception &except)
  {
    cout << "\n sim_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch(...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }

  return 0;
}

