/*!
* \brief - casdec_x test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <complex>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ----- SIM -----
#include "sim\_sim_lib.hpp"
#include "sim\_sim_exception.hpp"

// ----- SCI -----
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

int tf_sim_casdec_x()
{

  SIM::wgn_x		  wgn_x1;
  SIM::fir_x		  fir_x1, fir_x2, fir_x3;
  SIM::counter		cnt1, cnt2, cnt3;
  SIM::casdec_x   casdec_x1;

  // mav<4>
  const cvec c0 = cvec("0.25+0.0i, 0.25+0.0i, 0.25+0.0i, 0.25+0.0i");
  const int N = 5 * c0.length();
  int  CAS_DEC_ORDER = pow2i(3);

  cvec x_x;
  bvec ce, ce1, ce2, ce3, true_vec;
  cvec ya_x1, ya_x2, ya_x3;
  cmat ya, yb, yc;

  double epsilon = 1.0E-6;
  int err = 0;

  cout << "*** TEST SIM *** CASDEC_X " << endl;
  try
  {
    cout << fixed << setw(6) << setprecision(3);

    debug(1) << "CAS_DEC_ORDER = " << CAS_DEC_ORDER << endl;
    debug(1) << "c0 = " << c0 << endl;
    debug(1) << "N = " << N << endl;

    true_vec = ones_b(N);
    // clock and signal
    ce = ones_b(N);
    
    // source - random mean = (0.0+j0.0) sigma =1.0
    x_x = wgn_x1.generate(ce); 
    
    // discrete cascade settings
    fir_x1.set_taps(c0);
    fir_x1.reset();
    fir_x2.set_taps(c0);
    fir_x2.reset();
    fir_x3.set_taps(c0);
    fir_x3.reset();
    cnt1.set_N(2);
    cnt1.reset();
    cnt2.set_N(2);
    cnt2.reset();
    cnt3.set_N(2);
    cnt3.reset();
    
    // decimator settings
    casdec_x1.set_decimator_order(CAS_DEC_ORDER);
    casdec_x1.set_taps(c0);
    casdec_x1.reset();

    // discrete cascade proc
    ya_x1 = fir_x1.process(ce, x_x);
    ce1 = cnt1.generate(ce);
    ya_x2 = fir_x2.process(ce1, ya_x1);
    ce2 = cnt2.generate(ce1);
    ya_x3 = fir_x3.process(ce2, ya_x2);
    ce3 = cnt3.generate(ce2);
    ya.set_size(N, 2);
    ya.set_col(0, ya_x3);
    ya.set_col(1, to_cvec(to_vec(ce3), zeros(ce3.length())));
    debug(1) << "ya=" << endl << ya << endl;
    // decimator proc
    yb = casdec_x1.process(ce, x_x);
    debug(1) << "yb=" << endl << yb << endl;

    itpp_sci_assert((abs(ya.get_col(0) - yb.get_col(0)) < epsilon) == true_vec, "yb(:,0) ! = ya(:,0)");
    itpp_sci_assert(to_bvec(real(ya.get_col(1))) == to_bvec(real(yb.get_col(1))), "yb(:,1) ! = ya(:,1)");

  }
  catch (itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch (sim_exception &except)
  {
    cout << "\n sim_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch (...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;

}

