/*!
* \brief - circbuff, circbuff_x test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ----- SIM -----
#include "sim\_sim_lib.hpp"
#include "sim\_sim_exception.hpp"

// ----- SCI -----
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SIM;

int tf_sim_circbuff_x()
{
  SIM::circbuff	  cb1;
  SIM::circbuff_x	cb_x1;

  const int  M = 3;    // short vector size
  const int  N = 10;   // long vector size

  double v;
  vec a, b, ref, out_vec, y, null_vec;
  complexd v_x;
  cvec a_x, b_x, ref_x, out_vec_x, y_x, null_cvec;

  bvec cei, ceo;
  bmat ceio;

  int err = 0;

  cout << "*** TEST SIM *** circbuff " << endl;
  try
  {
    cout << fixed << setw(3) << setprecision(1);

    a = linspace(0, M - 1, M);        // [0,1,2]
    debug(1) << "a = " << a << endl;
    b = linspace(M, N - 1, N - M);    // [3,4,5,6,7,8,9]
    debug(1) << "b = " << b << endl;
    ref = concat(a, b);               // [0,1,2,3,4,5,6,7,8,9]
    debug(1) << "ref = " << ref << endl;

    a_x = to_cvec(a);
    debug(1) << "a_x = " << a_x << endl;
    b_x = to_cvec(b);
    debug(1) << "b_x = " << b_x << endl;
    ref_x = concat(a_x, b_x);
    debug(1) << "ref_x = " << ref_x << endl;

    null_vec.set_length(0);
    null_cvec.set_length(0);

    cb1.set_size(N);
    debug(1) << "cb1.get_size() = " << cb1.get_size() << endl;
    itpp_sci_assert(cb1.get_size() == N, "cb1.get_size() != N");

    cb_x1.set_size(N);
    debug(1) << "cb_x1.get_size() = " << cb_x1.get_size() << endl;
    itpp_sci_assert(cb_x1.get_size() == N, "cb_x1.get_size != N");

    // put [a|b] , peek, rev_peek, get(), get(), get(), get(-1), get(-1)
    cb1.put(a);
    cb1.put(b);
    cb1.peek(out_vec, -1);
    debug(1) << "peek(out_vec) = " << out_vec << endl;
    itpp_sci_assert(out_vec == ref, "peek(out_vec) != ref");

    cb1.peek_reverse(out_vec, -1);
    debug(1) << "peek_reverse(out_vec) = " << out_vec << endl;
    itpp_sci_assert(out_vec == reverse(ref), "peek_reverse(out_vec) != reverse(ref)");

    v = cb1.get();
    itpp_sci_assert(v == a[0], "v != a[0]");
    v = cb1.get();
    itpp_sci_assert(v == a[1], "v != a[1]");
    v = cb1.get();
    itpp_sci_assert(v == a[2], "v != a[2]");

    cb1.get(out_vec, -1);
    debug(1) << "get(out_vec) = " << out_vec << endl;
    itpp_sci_assert(out_vec == b, "out_vec != b");

    cb1.get(out_vec, -1);
    debug(1) << "get(out_vec) = " << out_vec << endl;
    itpp_sci_assert(out_vec == null_vec, "out_vec != null_vec");

    // process(M ticks), gen(N ticks)
    cei = to_bvec(to_ivec(ones(M)));
    ceo = to_bvec(to_ivec(zeros(M)));
    ceio.set_size(M, 2);
    ceio.set_col(0, cei);
    ceio.set_col(1, ceo);

    debug(1) << "cb1.nrof_elements= " << cb1.nrof_elements() << endl;
    itpp_sci_assert(cb1.nrof_elements() == 0, "cb1.nrof_elements() != 0");

    y = cb1.process(ceio, a);
    itpp_sci_assert(y == zeros(M), "y == zeros(M)");

    debug(1) << "cb1.nrof_elements= " << cb1.nrof_elements() << endl;
    itpp_sci_assert(cb1.nrof_elements() == M, "cb1.nrof_elements() != M");

    cei = to_bvec(to_ivec(ones(N)));
    y = cb1.generate(cei);
    ref = concat(concat(concat(a, a), a), a[0]);
    debug(1) << "y = " << y << endl;
    itpp_sci_assert(y == ref, "y != ref");

    // put [a|b] , peek, rev_peek, get(), get(), get(), get(-1), get(-1)

    cb_x1.put(a_x);
    cb_x1.put(b_x);
    cb_x1.peek(out_vec_x, -1);
    debug(1) << "peek(out_vec_x) = " << out_vec_x << endl;
    itpp_sci_assert(out_vec_x == ref_x, "peek(out_vec_x) != ref_x");

    cb_x1.peek_reverse(out_vec_x, -1);
    debug(1) << "peek_reverse(out_vec_x) = " << out_vec_x << endl;
    itpp_sci_assert(out_vec_x == reverse(ref_x), "peek_reverse(out_vec_x) != reverse(ref_x)");

    v_x = cb_x1.get();
    itpp_sci_assert(v_x == a_x[0], "v_x != a_x[0]");
    v_x = cb_x1.get();
    itpp_sci_assert(v_x == a_x[1], "v_x != a_x[1]");
    v_x = cb_x1.get();
    itpp_sci_assert(v_x == a_x[2], "v_x != a_x[2]");

    cb_x1.get(out_vec_x, -1);
    debug(1) << "get(out_vec_x) = " << out_vec_x << endl;
    itpp_sci_assert(out_vec_x == b_x, "out_vec_x != b_x");

    cb_x1.get(out_vec_x, -1);
    debug(1) << "get(out_vec_x) = " << out_vec_x << endl;
    itpp_sci_assert(out_vec_x == null_cvec, "out_vec != null_cvec");

    // process(M), gen(N)
    cei = to_bvec(to_ivec(ones(M)));
    ceo = to_bvec(to_ivec(zeros(M)));
    ceio.set_size(M, 2);
    ceio.set_col(0, cei);
    ceio.set_col(1, ceo);

    debug(1) << "cb_x1.nrof_elements= " << cb_x1.nrof_elements() << endl;
    itpp_sci_assert(cb_x1.nrof_elements() == 0, "cb_x1.nrof_elements() != 0");

    y_x = cb_x1.process(ceio, a_x);
    itpp_sci_assert(y_x == to_cvec(zeros(M)), "y_x != cvec(zeros(M))");

    debug(1) << "cb_x1.nrof_elements= " << cb_x1.nrof_elements() << endl;
    itpp_sci_assert(cb_x1.nrof_elements() == M, "cb_x1.nrof_elements() != M");

    cei = to_bvec(to_ivec(ones(N)));
    y_x = cb_x1.generate(cei);
    ref_x = concat(concat(concat(a_x, a_x), a_x), a_x[0]);
    debug(1) << "y_x = " << y_x << endl;
    itpp_sci_assert(y_x == ref_x, "y_x != ref_x");

  }
  catch (itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch (sim_exception &except)
  {
    cout << "\n sim_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch (...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}

