/*!
* \brief - sim_counter test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ----- SIM -----
#include "sim\_sim_lib.hpp"
#include "sim\_sim_exception.hpp"

// ----- SCI -----
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"


using namespace std;
using namespace itpp;
using namespace SIM;

int tf_sim_counter()
{
  SIM::counter cnt1;

  int N = 4;  // modulo
  int M = 4 * N; // number of ticks
  int c0, i;
  bvec ce, y, yref;
  int err = 0;

  cout << "*** TEST SIM *** counter"  << endl;
  try
  {

    // modulo
    N = 4;
    cnt1.set_N(N);

    debug(1) << "counter modulo N =" << cnt1.get_N() << endl;
    itpp_sci_assert(N == cnt1.get_N(), "N != get_N()");
    ce.set_length(M);
    ce.ones();
    yref = zeros_b(M);

    for(c0 = 0, i = 0; i < M; i++)
    {
      c0++;
      if(c0 == N)
      {
        c0 = 0;
        yref[i] = 1;
      }
    }
    debug(1) << "ce =" << endl << ce << endl;
    debug(1) << "yref =" << endl << yref << endl;
    y = cnt1.generate(ce);
    debug(1) << "y =" << endl << y << endl;
    itpp_sci_assert(y == yref, "y != yref");

    // last bit in y is 1, so state must be 0
    c0 = cnt1.get_state();
    debug(1) << "c0 =" << c0  << endl;
    itpp_sci_assert(c0 == 0, "c0 != 0");

    cnt1.set_state(N - 1);
    c0 = cnt1.get_state();
    debug(1) << "c0 =" << c0 << endl;
    itpp_sci_assert(c0 == N - 1, "c0 != N-1");

    cnt1.reset();
    c0 = cnt1.get_state();
    debug(1) << "c0 =" << c0 << endl;
    itpp_sci_assert(c0 == 0, "c0 != 0");

  }
  catch(itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch(sim_exception &except)
  {
    cout << "\n sim_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch(...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}

