/*xxx
 * \brief - SIM::ejp test application
 * compares ejp output with direct calculation
 * \author maki
 */

// ---- MSVC  ----
#include <iostream>
#include <complex>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ----- SIM -----
#include "sim\_sim_lib.hpp"
#include "sim\_sim_exception.hpp"

// ----- SCI -----
#include "_sci_assert.hpp"
#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SIM;


int tf_sim_ejp()
{
  SIM::nco nco1;	// default Nacc = 2^31
  SIM::ejp ejp1;

  const double L = 1.000;
  const double M = 4.0;
  const int    N = 2 * (int)M;
  const int    Nq_bits = 60;  // NCO phase accumulator format is Q1.Nq_bits

  bvec ce, true_vec;
  vec  x;
  mat nco_y;
  bvec nco_cy;
  vec nco_ph;
  cvec ejp_y, ejp_ref;
  cmat all;
  double epsilon = 1.0E-6;
  int err = 0;

  cout << "*** TEST SIM *** ejp" << endl;
  try
  {
    cout << fixed << setw(15) << setprecision(14);
    debug(1) << "epsilon =" << epsilon << endl;

    nco1.set_N(Nq_bits);
    debug(1) << "nco1.get_N() =" << nco1.get_N() << endl;
    itpp_sci_assert(nco1.get_N() == Nq_bits, "nco1.get_N() != Nq_bits");

    ce.set_length(N);
    ce.ones();
    true_vec.set_length(N);
    true_vec.ones();

    x.set_length(N);
    x.ones();
    x = (L / M) * x;
    debug(1) << "L/M =" << L << "/" << M << endl;

    nco_y = nco1.process(ce, x);
    nco_cy = (nco_y.get_col(0) != zeros(N));
    nco_ph = nco_y.get_col(1);


    ejp_y = ejp1.process(ce, nco_ph);
    ejp_ref = to_cvec(itpp::cos(2 * pi * nco_ph), itpp::sin(2 * pi * nco_ph));
    
    all.set_size(N, 2);
    all.set_col(0, ejp_y);
    all.set_col(1, ejp_ref);
    debug(3) << "[ejp_y|ejp_ref] = " << endl << all << endl;

    itpp_sci_assert((abs(itpp::real(ejp_y) - itpp::real(ejp_ref)) < epsilon) == true_vec, "abs(real(ejp_y) - real(ejp_ref)) > epsilon ");
    itpp_sci_assert((abs(itpp::imag(ejp_y) - itpp::imag(ejp_ref)) < epsilon) == true_vec, "abs(imag(ejp_y) - imag(ejp_ref)) > epsilon ");

  }
  catch (itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch (sim_exception &except)
  {
    cout << "\n sim_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch (...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;

}

