/*xxx
* \brief - SIM::fir test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <complex>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ----- SIM -----
#include "sim\_sim_lib.hpp"
#include "sim\_sim_exception.hpp"

// ----- SCI -----
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SIM;

int tf_sim_fir()
{
  SIM::fir fir1;

  const int TAPS = 5;
  const int N = 10;

  vec c0, c1;
  vec x;
  bvec ce;
  vec y, yref;
  vec z1;
  int err = 0;

  cout << "*** TEST SIM *** fir"  << endl;
  try
  {
    c0 = ones(TAPS) * 0.1;
    x = zeros(N);
    x[0] = 1.0;
    ce.set_length(N);
    ce.ones();
    debug(1) << "c0 = " << c0 << endl;
    debug(1) << "x = " << x << endl;
    debug(1) << "ce = " << ce << endl;

    fir1.set_taps(c0);
    fir1.reset();
    c1 = fir1.get_taps();
    z1 = fir1.get_state();
    debug(1) << "c1 = " << c1 << endl;
    debug(1) << "z1 = " << z1 << endl;
    itpp_sci_assert(c1 == c0, "c1 != c0");
    itpp_sci_assert(z1 == zeros(TAPS), "z1 != zeros(TAPS)");

    y = fir1.process(ce, x);
    yref = concat(c0, zeros(N - TAPS));
    debug(1) << "   y = " << y << endl;
    debug(1) << "yref = " << yref << endl;
    itpp_sci_assert(y == yref, "y != yref");
  }
  catch(itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch(sim_exception &except)
  {
    cout << "\n sim_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch(...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}
