/*xxx
* \brief - SIM::fir_x test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <complex>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ----- SIM -----
#include "sim\_sim_lib.hpp"
#include "sim\_sim_exception.hpp"

// ----- SCI -----
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SIM;

int tf_sim_fir_up()
{
  SIM::fir_up		fir_up1;
  SIM::fir_up_x	fir_up_x1;
  SIM::counter  cnt1;

  const int TAPS = 8;
  const int N = 2 * TAPS;

  vec c0, c1, z1;
  cvec c_x0, c_x1;
  vec x;
  cvec x_x, z_x;
  bvec cei, ceo;
  bmat ce;
  vec y, y_ref;
  cvec y_x, y_x_ref;

  int err = 0;

  cout << "*** TEST SIM *** fir_up" << endl;
  try
  {

    debug(1) << "Number of taps TAPS = " << TAPS << endl;
    debug(1) << "Number of samples N = " << N << endl;

    cnt1.set_N(TAPS);
    cnt1.set_state(TAPS - 1);
    ceo.set_length(N);
    ceo.ones();
    // cei is output of by UP counter
    cei = cnt1.generate(ceo);
    // up sample
    ce.set_size(N, 2);
    ce.set_col(0, cei);
    ce.set_col(1, ceo);
    debug(3) << "ce.' = [cei|ceo].' \n" << ce.transpose() << endl;

    c0 = ones(TAPS) * (1.0 / TAPS);
    debug(3) << "c0 = " << c0 << endl;
    // set_up UP filter
    fir_up1.set_taps(c0);
    fir_up1.reset();
    c1 = fir_up1.get_taps();
    z1 = fir_up1.get_state();
    itpp_sci_assert(c1 == c0, "c1 != c0");
    itpp_sci_assert(z1 == zeros(TAPS), "z1 != zeros(TAPS)");

    // set up input signal
    x.set_length(N);
    x.ones();

    y = fir_up1.process(ce, x);
    //  y should be constant signal 0.125
    y_ref = ones(N) * (1.0 / TAPS);

    debug(3) << "    x = " << x << endl;
    debug(3) << "    y = " << y << endl;
    debug(3) << "y_ref = " << y_ref << endl;
    itpp_sci_assert(y == y_ref, "y != y_ref");


    // filter is complex MAV - 1/8
    c_x0 = to_cvec(c0, c0);
    debug(3) << "c_x0 = " << c_x0 << endl;
    // set up input signal
    x_x.set_length(N);
    x_x = to_cvec(x, zeros(N));

    fir_up_x1.set_taps(c_x0);
    fir_up_x1.reset();
    c_x1 = fir_up_x1.get_taps();
    z_x = fir_up_x1.get_state();
    itpp_sci_assert(c_x1 == c_x0, "c_x1 != c_x0");
    itpp_sci_assert(z_x == to_cvec(zeros(TAPS), zeros(TAPS)) , "z_x != zeros(TAPS)");

    y_x = fir_up_x1.process(ce , x_x);
    //  y should be constant signal 0.125+j0.125
    y_x_ref = to_cvec(ones(N), ones(N)) * (1.0 / TAPS);

    debug(3) << "    x_x =" << x_x << endl;
    debug(3) << "    y_x =" << y_x << endl;
    debug(3) << "y_x_ref =" << y_x_ref << endl;
    itpp_sci_assert(y_x == y_x_ref, "y_x != y_x_ref");

  }
  catch(itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch(sim_exception &except)
  {
    cout << "\n sim_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch(...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;

}