/*xxx
* \brief - SIM::fir_x test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <complex>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ----- SIM -----
#include "sim\_sim_lib.hpp"
#include "sim\_sim_exception.hpp"

// ----- SCI -----
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SIM;


int tf_sim_fir_x()
{
  SIM::fir_x fir_x1;

  const int TAPS = 5;
  const int N = 10;

  cvec c0, c1;
  cvec x;
  bvec ce;
  cvec y, yref;
  cvec z1, zx;
  int err = 0;

  cout << "*** TEST SIM *** fir_x "  << endl;
  try
  {
    c0 = 0.1 * to_cvec(ones(TAPS), ones(TAPS));
    x = to_cvec(zeros(N) , zeros(N));
    x[0] = complexd(1.0, 0.0);
    ce.set_length(N);
    ce.ones();
    debug(1) << "c0 = " << c0 << endl;
    debug(1) << "x = " << x << endl;
    debug(1) << "ce = " << ce << endl;

    fir_x1.set_taps(c0);
    fir_x1.reset();
    c1 = fir_x1.get_taps();
    z1 = fir_x1.get_state();
    debug(1) << "c1 = " << c1 << endl;
    debug(1) << "z1 = " << z1 << endl;
    itpp_sci_assert(c1 == c0, "c1 != c0");
    zx = to_cvec(zeros(TAPS), zeros(TAPS));
    itpp_sci_assert(z1 == zx, "z1 != zeros(TAPS)");
    y = fir_x1.process(ce, x);
    zx = to_cvec(zeros(N - TAPS), zeros(N - TAPS));
    yref = concat(c0, zx);
    debug(1) << "   y = " << y << endl;
    debug(1) << "yref = " << yref << endl;
    itpp_sci_assert(y == yref, "y != yref");

  }
  catch(itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch(sim_exception &except)
  {
    cout << "\n sim_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch(...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;

}

