/*!
* \brief - iq2ap, ap2iq test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ----- SIM -----
#include "sim\_sim_lib.hpp"
#include "sim\_sim_exception.hpp"

// ----- SCI -----
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SIM;

int tf_sim_iq2ap()
{
  SIM::qam_mod		qmod1;
  SIM::qam_dem		qdem1;
  SIM::iq2ap		  iq2ap1;
  SIM::ap2iq		  ap2iq1;

  const int     M = 16;     // Symbol size Q16

  bvec ce, true_vec;
  cvec cv;
  mat ap;
  cvec iq;
  ivec ivx, ivy;
  mat y;

  int err = 0;
  double epsilon = 1.0E-6;

  cout << "*** TEST SIM *** iq2ap " << endl;
  try
  {
    cout << fixed << setw(7) << setprecision(3);
    debug(1) << "epsilon = " << epsilon << endl;
    debug(1) << "QAM size M = " << M << endl;

    ce.set_length(M);
    ce.ones();
    true_vec.set_length(M);
    true_vec.ones();

    qmod1.set_size(M);
    qdem1.set_size(M);

    ivx = to_ivec(linspace(0, M - 1, M));
    cv = qmod1.process(ce, ivx);
    ap = iq2ap1.process(ce, cv);
    iq = ap2iq1.process(ce, ap);
    ivy = qdem1.process(ce, iq);
    y.set_size(M, 8);
    y.set_col(0, to_vec(ivx));
    y.set_col(1, to_vec(ivy));
    y.set_col(2, real(cv));
    y.set_col(3, imag(cv));
    y.set_col(4, real(iq));
    y.set_col(5, imag(iq));
    y.set_col(6, ap.get_col(0));
    y.set_col(7, ap.get_col(1));
    debug(1) << "y  = " << endl;
    debug(1) << y << endl;

    itpp_sci_assert(ivx == ivy, "ivx!=ivy");
    itpp_sci_assert((abs(cv-iq) < epsilon) == true_vec, "cv!=iq");
  }
  catch (itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch (sim_exception &except)
  {
    cout << "\n sim_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch (...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}

