/*!
* \brief - sim_lsr test app - pass PRBS symbol sequence through LSR acting as FIFO
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <complex>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ----- SIM -----
#include "sim\_sim_lib.hpp"
#include "sim\_sim_exception.hpp"

// ----- SCI -----
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SIM;


int tf_sim_lsr()
{

  SIM::lsr lsr1;
  SIM::lfsr lfsr1;

  int N, W, L, PRBS, D, T;
  bvec z0, z1;
  bvec ce, ce_ref;
  bmat y, x, x_ref, y_ref;
  int err = 0;

  cout << "*** TEST SIM *** lsr"  << endl;
  try
  {
    // Symbol size
    W = 4;
    // LSR FIFO lenght in symbols
    D = 3;
    // ----------------------------------
    // set LSR memory lenght
    L = D * W;
    // clock ticks
    N = 2 * D;

    // set length and symbol_size as minimal setup
    debug(1) << "lsr1.set_length=" << L << endl;
    lsr1.set_length(L);
    debug(1) << "lsr1.set_symbol_size=" << W << endl;
    lsr1.set_symbol_size(W);

    T = lsr1.get_length();
    debug(1) << "lsr1.get_lenth() T =" << T << endl;
    itpp_sci_assert(T == L, "T != L");

    T = lsr1.get_symbol_size();
    debug(1) << "lsr1.get_symbol_size() T =" << T << endl;
    itpp_sci_assert(T == W, "T != W");

    // test paterns by prbs generator 2^4-1
    PRBS = 4;
    // set LFSR as prbs generator
    debug(1) << "lsfr1.set_prbs PRBS=" << PRBS << endl;
    lfsr1.set_prbs(PRBS);
    debug(1) << "lsfr1.set_symbol_size W=" << W << endl;
    lfsr1.set_symbol_size(W);

    // generate ce
    ce.set_length(N);
    ce.ones();
    // generate symbols
    x = lfsr1.generate(ce);
    x_ref = bmat("1 1 0 0; 1 0 1 0; 0 1 1 1; 0 1 0 0; 0 1 1 0; 1 1 0 1");
    ce_ref = bvec("1 1 1 1 1 1");
    y_ref = bmat("0 0 0 0; 0 0 0 0; 0 0 0 0; 1 1 0 0; 1 0 1 0; 0 1 1 1");
    debug(1) << "   ce = \n" << ce << endl;
    debug(1) << "    x = \n" << x << endl;
    debug(1) << " xref = \n" << x_ref << endl;
    itpp_sci_assert(x == x_ref, "x != x_ref");
    itpp_sci_assert(ce == ce_ref, "ce != ce_ref");

    y = lsr1.process(ce, x);
    debug(1) << "    y = \n"  << y << endl;
    debug(1) << "y_ref = \n" << y_ref << endl;
    itpp_sci_assert(y == y_ref, "y != y_ref");

  }
  catch(itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch(sim_exception &except)
  {
    cout << "\n sim_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch(...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}

