/*!
 * \brief -  SIM::mix, SIM::mix_x test application
 * compares output with the pre-calculated reference
 * \author maki
 */

// ---- MSVC  ----
#include <iostream>
#include <complex>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ----- SIM -----
#include "sim\_sim_lib.hpp"
#include "sim\_sim_exception.hpp"

// ----- SCI -----
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SIM;


int tf_sim_mix_x()
{
  SIM::wgn		wgn1;
  SIM::wgn_x	wgn_x1;
  SIM::mix		mix1;
  SIM::mix_x	mix_x1;

  const int N = 10;
  bvec ce;
  vec  x1, x2, y1, y1_ref;
  mat  x;
  cvec x_x1, x_x2, y_x1, y_x1_ref;
  cmat x_x;
  int err = 0;

  cout << "*** TEST SIM *** mix_x" << endl;
  try
  {

    debug(1) << "Number of samples N = " << N << endl;

    ce.set_length(N);
    ce.ones();

    x1 = wgn1.generate(ce);
    x2 = wgn1.generate(ce);
    x.set_size(N, 2);
    x.set_col(0, x1);
    x.set_col(1, x2);

    x_x1 = wgn_x1.generate(ce);
    x_x2 = wgn_x1.generate(ce);
    x_x.set_size(N, 2);
    x_x.set_col(0, x_x1);
    x_x.set_col(1, x_x2);

    y1 = mix1.process(ce, x);
    y1_ref = itpp::elem_mult(x1,x2);

    debug(3) << "    x1 =" << x1 << endl;
    debug(3) << "    x2 =" << x2 << endl;
    debug(3) << "    y1 = " << y1 << endl;
    debug(3) << "y1_ref = " << y1_ref << endl;

    y_x1 = mix_x1.process(ce, x_x);
    y_x1_ref = itpp::elem_mult(x_x1,x_x2);

    debug(3) << "    x_x1 =" << x_x1 << endl;
    debug(3) << "    x_x2 =" << x_x2 << endl;
    debug(3) << "    y_x1 = " << y_x1 << endl;
    debug(3) << "y_x1_ref = " << y_x1_ref << endl;

    itpp_sci_assert(y1 == y1_ref, "y1 != y1_ref");
    itpp_sci_assert(y_x1 == y_x1_ref, "y_x1 != y_x1_ref");

  }
  catch (itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch (sim_exception &except)
  {
    cout << "\n sim_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch (...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;

}

