/*!
* \brief - SIM::pam_mod, SIM::pam_dem test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <complex>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ----- SIM -----
#include "sim\_sim_lib.hpp"
#include "sim\_sim_exception.hpp"

// ----- SCI -----
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SIM;

// test of sim pam_mod pam_dem
int tf_sim_pam()
{
  SIM::pam_mod pam_mod1;
  SIM::pam_dem pam_dem1;

  const int M = 8;
  const vec v_ref = vec("-0.8750000, -0.6250000, -0.3750000, -0.1250000, 0.1250000, 0.3750000, 0.6250000, 0.8750000");

  bvec ce, true_vec;
  vec v;
  ivec ivx, ivy;
  double epsilon = 1.0E-6;
  int err = 0;

  cout << "*** TEST SIM *** PAM " << endl;
  try
  {
    cout << fixed << setw(10) << setprecision(8);

    ivx = to_ivec(linspace(0, M - 1, M)); // [0,1,2...]
    ce = ones_b(M);
    true_vec = ones_b(M);

    pam_mod1.set_size(M);
    pam_dem1.set_size(M);

    debug(1) << " Mod M = " << pam_mod1.get_size() << endl;
    debug(1) << " Mod scale = " << pam_mod1.get_scale() << endl;
    debug(1) << " Dem M = " << pam_dem1.get_size() << endl;
    debug(1) << " Dem scale = " << pam_dem1.get_scale() << endl;

    itpp_sci_assert(pam_mod1.get_size() == M, "pam_mod1.get_size() != M");
    itpp_sci_assert(pam_dem1.get_size() == M, "pam_dem1.get_size() != M");
    
    v =  pam_mod1.process(ce, ivx);
    ivy = pam_dem1.process(ce, v);

    debug(1) << "    ivx = " << ivx << endl;
    debug(1) << "     v = " << v << endl;
    debug(1) << "    ivy = " << ivy << endl;

    itpp_sci_assert(ivy == ivx, "ivy ! =ivx");
    itpp_sci_assert((abs(v - v_ref) < epsilon) == true_vec, "v ! = v_ref");

  }
  catch (itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch (sim_exception &except)
  {
    cout << "\n sim_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch (...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}

