/*!
* \brief - psk_mod, psk_dem test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <complex>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ----- SIM -----
#include "sim\_sim_lib.hpp"
#include "sim\_sim_exception.hpp"

// ----- SCI -----
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SIM;

int tf_sim_psk()
{
  SIM::psk_mod psk_mod1;
  SIM::psk_dem psk_dem1;

  const  int  M = 8;      // Symbol size => 8PSK
  const cvec  cv_ref = cvec("0.7071068+0.0000000i, 0.5000000+0.5000000i, 0.0000000+0.7071068i, -0.5000000+0.5000000i, -0.7071068+0.0000000i, -0.5000000-0.5000000i, 0.0000000-0.7071068i, 0.5000000-0.5000000i");

  bvec ce, true_vec;
  cvec cv;
  ivec ivx, ivy;
  double epsilon = 1.0E-6;

  int err = 0;

  cout << "*** TEST SIM *** PSK " << endl;
  try
  {

    cout << fixed << setw(5) << setprecision(2);

    ivx = to_ivec(linspace(0, M - 1, M));        // [0,1,2...]
    ce = ones_b(M);
    true_vec = ones_b(M);

    psk_mod1.set_size(M);
    psk_dem1.set_size(M);

    debug(1) << "  mod M = " << psk_mod1.get_size() << endl;
    itpp_sci_assert(psk_mod1.get_size() == M, "psk_mod1.get_size() != M");
    debug(1) << "  dem M = " << psk_dem1.get_size() << endl;
    itpp_sci_assert(psk_dem1.get_size() == M, "psk_dem1.get_size() != M");

    cv = psk_mod1.process(ce, ivx);
    ivy = psk_dem1.process(ce, cv);

    debug(1) << "    ivx = " << ivx << endl;
    debug(1) << "     cv = " << cv << endl;
    debug(1) << "    ivy = " << ivx << endl;

    itpp_sci_assert(ivy == ivx, "ivy ! =ivx");
    itpp_sci_assert( (abs(cv - cv_ref) < epsilon) == true_vec, "cv ! = cv_ref");
  }
  catch (itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch (sim_exception &except)
  {
    cout << "\n sim_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch (...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}

