/*!
* \brief - qam_mod, qam_dem test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <complex>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ----- SIM -----
#include "sim\_sim_lib.hpp"
#include "sim\_sim_exception.hpp"

// ----- SCI -----
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SIM;

int tf_sim_qam()
{
  SIM::qam_mod qmod1;
  SIM::qam_dem qdem1;

  const  int  M = 4;
  int  m;
  bvec ce ;
  cvec cv, cv_ref;
  ivec ivx, ivy;
  int err = 0;

  cout << "*** TEST SIM *** qam "  << endl;
  try
  {
    // Test constelation is QPSK
    qmod1.set_size(M);
    qdem1.set_size(M);

    m = qmod1.get_size();
    debug(1) << "  mod M = " << m << endl;
    itpp_sci_assert(m == M, "m != M");
    m = qdem1.get_size();
    debug(1) << "  dem M = " << m << endl;
    itpp_sci_assert(m == M, "m != M");

    cv.set_length(M);
    ivx.set_length(M);
    ivy.set_length(M);
    ivx = ivec("0, 1, 2, 3");
    cv_ref = cvec("0.50000+0.50000i, -0.50000+0.50000i, 0.50000-0.50000i, -0.50000-0.50000i");

    ce = ones_b(M);
    cv = qmod1.process(ce, ivx);
    ivy = qdem1.process(ce, cv);

    debug(1) << "    ivx = " << ivx << endl;
    debug(1) << "     cv = " << cv << endl;
    debug(1) << " cv_ref = " << cv_ref << endl;
    debug(1) << "    ivy = " << ivx << endl;
    debug(1) << "ivy_ref = " << ivx << endl;
    itpp_sci_assert(cv == cv_ref, "cv != cv_ref");
    itpp_sci_assert(ivy == ivx, "ivy ! =ivx");
  }
  catch (itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch (sim_exception &except)
  {
    cout << "\n sim_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch (...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}

