/*xxx
* \brief - SIM::rms, SIM::rms_x test application
*  Check RMS for DC and complex DC
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <complex>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ----- SIM -----
#include "sim\_sim_lib.hpp"
#include "sim\_sim_exception.hpp"

// ----- SCI -----
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SIM;


int tf_sim_rms()
{
  SIM::rms		rms1;
  SIM::rms_x	rms_x1;

  const int MAV = 10;   // mav lenght
  const int N = 20;     // sequence lenght
  bvec ce, true_vec;
  vec x1;
  cvec x_x1;
  vec y1, y1_ref;
  vec y_x1, y_x1_ref;
  double epsilon = 1.0E-5;
  int err = 0;

  cout << "*** TEST SIM *** rms"  << endl;
  try
  {

    ce.set_length(N);
    ce.ones();
    true_vec.set_length(N);
    true_vec.ones();
    x1.set_length(N);
    x1.ones();
    x_x1 = to_cvec(x1, x1); // (1.0+j1.0)
    debug(1) << "epsilon =" << epsilon << endl;
    debug(1) << "    ce =" << ce << endl;

    rms1.set_size(MAV);
    itpp_sci_assert(rms1.get_size() == MAV, "rms1.get_size() != MAV");
    rms_x1.set_size(MAV);
    itpp_sci_assert(rms_x1.get_size() == MAV, "rms_x1.get_size() != MAV");

    //       sqrt(MAV 1.0 step response)
    //       sqrt(0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.0 1.0......)
    y1_ref = vec("0.31623 0.44721 0.54772 0.63246 0.70711 0.77460 0.83666 0.89443 0.94868 1.00000 1.00000 1.00000 1.00000 1.00000 1.00000 1.00000 1.00000 1.00000 1.00000 1.00000");
    y1 = rms1.process(ce, x1);
    debug(1) << "    x1 =" << x1 << endl;
    debug(1) << "    y1 = " << y1 << endl;
    debug(1) << "y1_ref = " << y1_ref << endl;
    debug(1) << "(abs(y1 - y1_ref) < epsilon) = \n" << (abs(y1 - y1_ref) < epsilon) << endl;
    itpp_sci_assert((abs(y1 - y1_ref) < epsilon) == true_vec, "abs(y1 - y1_ref) > epsilon ");

    //   sqrt(MAV sqrt(2) step response)
    //   sqrt(2)*sqrt(0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.0 1.0......)
    y_x1_ref = vec("0.44721 0.63246 0.77460 0.89443 1.00000 1.09545 1.18322 1.26491 1.34164 1.41421 1.41421 1.41421 1.41421 1.41421 1.41421 1.41421 1.41421 1.41421 1.41421 1.41421");
    debug(1) << "      ce =" << ce << endl;
    debug(1) << "    x_x1 = " << x_x1 << endl;
    y_x1 = rms_x1.process(ce, x_x1);
    debug(1) << "    y_x1 = " << y_x1 << endl;
    debug(1) << "y_x1_ref = " << y_x1_ref << endl;
    debug(1) << "(abs(y_x1 - y1_x1_ref) < epsilon) = \n" << (abs(y_x1 - y_x1_ref) < epsilon) << endl;
    itpp_sci_assert((abs(y_x1 - y_x1_ref) < epsilon) == true_vec, "abs(y_x1 - y_x1_ref) > epsilon ");

  }
  catch(itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch(sim_exception &except)
  {
    cout << "\n sim_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch(...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;

}

