/*!
* \brief - tedg_x test application
* \author maki
*/

// ---- MSVC  ----
#include <iostream>
#include <iomanip>

// ---- ITPP  ----
#include "itpp/itbase.h"

// ----- SIM -----
#include "sim\_sim_lib.hpp"
#include "sim\_sim_exception.hpp"

// ----- SCI -----
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"

using namespace std;
using namespace itpp;
using namespace SIM;


int tf_sim_tedg_x()
{
  SIM::tedg_x	tedg_x1;

  bvec true_vec;
  bmat ceio;
  vec  x;
  cvec x_x;
  cvec y_x, y_x_ref;
  const double epsilon = 1.0E-6;

  cout << "*** TEST SIM *** tedg_x " << endl;
  try
  {
    true_vec = ones_b(3);

    tedg_x1.set_mode(TEDG_MODE_STD);
    // ceio[cei|ceo]
    ceio = bmat("1 1; 1 0; 1 1");
    // perfect timing for triangle waveform
    x = vec("1.0 0.0 -1.0");
    x_x = to_cvec(x, x);
    y_x_ref = cvec("0.000+0.000i, 0.000+0.000i, 0.000+0.000i");
    y_x = tedg_x1.process(ceio, x_x);
    debug(1) <<  "y_x  = "  << endl << y_x << endl;
    itpp_sci_assert((abs(y_x - y_x_ref) < epsilon) == true_vec, "y_x != y_x_ref");

    // late timing for triangle waveform
    x = vec("0.5 -0.5 -0.5");
    x_x = to_cvec(x, x);
    y_x_ref = cvec("-0.500-0.500i, -0.500-0.500i, 0.500+0.500i");
    y_x = tedg_x1.process(ceio, x_x);
    debug(1) << "y_x  = " << endl << y_x << endl;
    itpp_sci_assert((abs(y_x - y_x_ref) < epsilon) == true_vec, "y_x != y_x_ref");

    // early timing for triangle waveform
    x = vec("0.5 0.5 -0.5");
    x_x = to_cvec(x, x);
    y_x_ref = cvec("-0.500-0.500i, -0.500-0.500i, -0.500-0.500i");
    y_x = tedg_x1.process(ceio, x_x);
    debug(1) << "y_x  = " << endl << y_x << endl;
    itpp_sci_assert((abs(y_x - y_x_ref) < epsilon) == true_vec, "y_x != y_x_ref");

  }
  catch(sim_exception except)
  {
    cout << "\n sim exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
  }
  return 0;
}

