/*xxxx
 * \brief - SIM::wgn, SIM::wgn_x test application
 * checks RMS of wgn and complex wgn
 * \author maki
 *
 */

// ---- MSVC  ----

#include <iostream>
#include <complex>
#include <iomanip>

/// ---- ITPP  ----
#include "itpp/itbase.h"
#include <itpp/stat/misc_stat.h>

// ----- SIM -----
#include "sim\_sim_lib.hpp"
#include "sim\_sim_exception.hpp"

// ----- SCI -----
#include "_sci_assert.hpp"

#include "__debug_level.h"
#include "debug.hpp"


using namespace std;
using namespace itpp;
using namespace SIM;

int tf_sim_wgn()
{
  SIM::wgn		wgn1;
  SIM::wgn_x	wgn_x1;

  const int N = 1000;      // sequence lenght

  bvec ce;

  vec x1;
  double sigma_x1;
  double mean_x1;
  double sigma_x1_ref = 0.1;
  double mean_x1_ref =  0.2;

  cvec x_x1;
  double sigma_x_x1;
  complexd mean_x_x1;
  double sigma_x_x1_ref = 0.15;
  complexd mean_x_x1_ref = complexd(0.25, -0.25);

  double epsilon = 3.0E-1; // 30 %
  int err = 0;

  cout << "*** TEST SIM *** wgn" << endl;
  try
  {

    debug(1) << "epsilon = " << epsilon << endl;
    debug(1) << "Number of samples N = " << N << endl;

    ce.set_length(N);
    ce.ones();

    wgn1.set_sigma(sigma_x1_ref);
    itpp_sci_assert(wgn1.get_sigma() == sigma_x1_ref, "wgn1.get_sigma() != sigma_x1_ref");
    wgn1.set_mean(mean_x1_ref);
    itpp_sci_assert(wgn1.get_mean() == mean_x1_ref, "wgn1.get_mean() != mean_x1_ref");

    wgn_x1.set_sigma(sigma_x_x1_ref);
    itpp_sci_assert(wgn_x1.get_sigma() == sigma_x_x1_ref, "wgn_x1.get_sigma() != sigma_x_x1_ref");
    wgn_x1.set_mean(mean_x_x1_ref);
    itpp_sci_assert(wgn_x1.get_mean() == mean_x_x1_ref, "wgn_x1.get_mean() != mean_x_x1_ref");

    x1 = wgn1.generate(ce);
    mean_x1 = mean(x1);
    debug(1) << "mean(x1) =" << mean_x1 << endl;
    debug(1) << "mean_x1_ref =" << mean_x1_ref << endl;
    if(mean_x1_ref != 0.0)
    {
      itpp_sci_assert(abs((mean_x1 - mean_x1_ref) / mean_x1_ref) < epsilon, "abs((mean_x1 - mean_x1_ref) / mean_x1_ref) > epsilon");
    }
    // variance = E[(X-m)^2] = E[x^2] | X=x+m
    sigma_x1 = std::sqrt(variance<double>(x1));
    debug(1) << "sigma(x1) =" << sigma_x1 << endl;
    debug(1) << "sigma_x1_ref =" << sigma_x1_ref << endl;
    itpp_sci_assert((sigma_x1 - sigma_x1_ref) < epsilon * sigma_x1_ref , "(sigma_x1 - sigma_x1_ref)/sigma_x1_ref > epsilon*sigma_x1_ref");


    x_x1 = wgn_x1.generate(ce); // mean = (0.0+j0.0) sigma =1.0
    mean_x_x1 = mean(x_x1);
    debug(1) << "mean(x_x1) =" << mean(x_x1) << endl;
    debug(1) << "mean(x_x1_ref) =" << mean_x_x1_ref << endl;
    if(abs(mean_x_x1_ref) != 0.0)
    {
      itpp_sci_assert((abs(mean_x1) - abs(mean_x1_ref)) / abs(mean_x1_ref) < epsilon, "abs((abs(mean_x1) - abs(mean_x1_ref)) / abs(mean_x1_ref) > epsilon");
    }
    // variance = E[(X-m)*(conj(X)-conj(m))] = E[x*conj(x)] | X=x+m
    sigma_x_x1 = std::sqrt(variance(x_x1));
    debug(1) << "sigma(x_x1) =" << sigma_x_x1 << endl;
    debug(1) << "sigma(x_x1_ref) =" << sigma_x_x1_ref << endl;
    itpp_sci_assert((sigma_x_x1 - sigma_x_x1_ref) < epsilon * sigma_x_x1_ref, "(sigma_x_x1 - sigma_x_x1_ref)/sigma_x_x1_ref > epsilon*sigma_x1_ref");

  }
  catch(itpp_sci_assert_exception &except)
  {
    cout << "\n itpp_sci_assert_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -1;
  }
  catch(sim_exception &except)
  {
    cout << "\n sim_exception:" << endl << except.get_msg() << ":" << except.get_info() << endl;
    err = -2;
  }
  catch(...)
  {
    cout << "\n unknown exception ???" << endl;
    err = -3;
  }
  return err;
}

