#ifndef _DBG_HPP_
#define _DBG_HPP_

#include <iostream>

using std::ostream;

// This is a function pointer that takes a stream as input and returns the stream.
typedef ostream& (*STRFUNC)(ostream&);

class dbg
{
private:
  bool m_output;

public:
  dbg(int level)
    : m_output(level != 0)
  {}

  // This covers all except for std::endl
  template<typename T> dbg& operator<<(T t)
  {
    if(m_output)
    {
      std::cout << t;
      return *this;
    }
    else
      return *this;
  }

  // This covers functions like std::endl
  dbg& operator<<(STRFUNC func)
  {
    if(m_output)
    {
      // Apply the function
      func(std::cout);
    }
    // But return the debug object
    return *this;
  }

};

#endif
