/*xxx
* \brief - definition of virtual base class
* \author maki
*/

#ifndef SCI_BASE_HPP
#define SCI_BASE_HPP

#include "_sci_enum_def.h"

// ---- ITPP  ----
#include "itpp\itbase.h"
#include "sci\_sci_var.hpp"
#include "sci\_sci_exception.hpp"

using namespace std;
using namespace itpp;

namespace SCI
{

/*!
* \brief virtual base class
* \ref SCI_API API functions
<pre>
sci_create()
sci_set()
sci_get()
sci_exec()
sci_gen()
sci_proc()
sci_destroy()
</pre>
* Virtual functions are for getting functions of derived class through the pointers of the base class
* \n input parameters are defined by pointer to sci_var objects 
* \n returned pointers to sci_var objects points to newly created sci_var objects
* \note when function returns a pointer - this indicates that an new() object was created,
* \n and it should be deleted at some point by application to avoid memory leaks
*/
class sci_base
{
public:

  /*!
  \brief constructor
  */
  sci_base()
  {
  };

  /*!
  \brief virtual destructor
  */
  virtual ~sci_base()
  {
  };

  /*!
  \brief creates SCI object and returns pointer to it
  */
  sci_base* create(int sci_type);

  /*!
  \brief destroy SCI object
  */
  virtual void destroy()
  {
    return;
  }

  /*!
  \brief set parameters of the SCI object
  \param param - type of parameter to set
  \param p_v - pointer to sci_var object with parameters value
  */
  virtual void set(int param, sci_var* p_v)
  {
    throw sci_exception("sci_base::set - should have been overriden");
    return;
  }

  /*!
  \brief get parameters of the SCI object
  \param param - type of parameter to get
  \return - pointer to sci_var object with parameters value
  */
  virtual sci_var* get(int param)
  {
    sci_var* p_v;
    p_v = NULL;
    throw sci_exception("sci_base::get - should have been overriden");
    return (p_v);
  }

  /*!
  \brief execute command for a SCI object
  \param command - type of command to execute
  */
  virtual void exec(int command)
  {
    throw sci_exception("sci_base::exec - should have been overriden");
    return;
  }

  /*!
  \brief generate data using a SCI object
  \param p_v_ce - pointer to sci_var with ce[] clock enable signal
  \return - pointer to sci_var object with generated values
  */
  virtual sci_var*  gen(sci_var* p_v_ce)
  {
    sci_var *p_y;
    p_y = NULL;
    throw sci_exception("sci_base::gen - should have been overriden");
    return (p_y);
  }

  /*!
  \brief process data  using a SCI object
  \param p_v_ce - pointer to sci_var with ce[] clock enable signal
  \param p_v_x - pointer to sci_var with x[] input signal
  \return - pointer to sci_var object with output values
  */
  virtual sci_var* proc(sci_var* p_v_ce, sci_var* p_v_x)
  {
    sci_var* p_y;
    p_y = NULL;
    throw sci_exception("sci_base::proc - should have been overriden");
    return (p_y);
  }
};


}

#endif
