/*xxx
 * \brief templated EMULATOR of SCI_API
 * \author maki
 */
#ifndef SCI_EMU_HPP
#define SCI_EMU_HPP

#include "sci\_sci_base.hpp"
#include "sci\_sci_create_sci_var.hpp"

namespace SCI
{

/// \cond EMU_DOC

void sci_var_value_get(sci_var* p_v, double *p_double);
void sci_var_value_get(sci_var* p_v, vec *p_vec);
void sci_var_value_get(sci_var* p_v, mat *p_mat);

void sci_var_value_get(sci_var* p_v, int *p_int);
void sci_var_value_get(sci_var* p_v, ivec *p_ivec);
void sci_var_value_get(sci_var* p_v, imat *p_imat);

void sci_var_value_get(sci_var* p_v, bool *p_bool);
void sci_var_value_get(sci_var* p_v, bvec *p_bvec);
void sci_var_value_get(sci_var* p_v, bmat *p_bmat);

void sci_var_value_get(sci_var* p_v, complex<double> *p_complex);
void sci_var_value_get(sci_var* p_v, cvec *p_cvec);
void sci_var_value_get(sci_var* p_v, cmat *p_cmat);

//! \brief - emulation of scilab syntax
sci_base* EMU_SCI_CREATE(int sci_type);

//! \brief - emulation of scilab syntax
void EMU_SCI_EXEC(sci_base *p_dev, int sci_command);

//! \brief - emulation of scilab syntax
void EMU_SCI_DESTROY(sci_base *p_dev);

//--------------- TEMPLATES --------------
//! \brief - emulation of scilab syntax by templated function
template <class P >
void EMU_SCI_SET(sci_base *p_dev, int sci_param, P param)
{
  sci_var *p_v;

  p_v = create_sci_var(&param);
  sci_set(p_dev, sci_param, p_v);
  delete(p_v);
}

//! \brief - emulation of scilab syntax by templated function
template <class P >
P EMU_SCI_GET(sci_base *p_dev, int sci_param)
{
  sci_var *p_v;
  P y;

  p_v = sci_get(p_dev, sci_param);
  sci_var_value_get(p_v, &y);
  delete(p_v);

  return (y);
}

//! \brief - emulation of scilab syntax by templated function
template <class Y, class CE>
Y EMU_SCI_GEN(sci_base *p_dev, CE v_ce)
{
  Y y;
  sci_var *p_y, *p_v_ce;

  p_v_ce = create_sci_var(&v_ce);
  p_y = sci_gen(p_dev, p_v_ce);
  sci_var_value_get(p_y, &y);
  delete(p_y);
  delete(p_v_ce);

  return (y);
}

//! \brief - emulation of scilab syntax by templated function
template <class Y, class CE, class X>
Y EMU_SCI_PROC(sci_base *p_dev, CE v_ce, X v_x)
{
  Y y;
  sci_var *p_y, *p_v_ce, *p_v_x;

  p_v_ce = create_sci_var(&v_ce);
  p_v_x = create_sci_var(&v_x);
  p_y = sci_proc(p_dev, p_v_ce, p_v_x);
  sci_var_value_get(p_y, &y);
  delete(p_y);
  delete(p_v_ce);
  delete(p_v_x);

  return (y);

}

/// \endcond

}

#endif
