/*!
* \brief - enumerated definitions
* \author maki
*/

#ifndef SCI_ENUM_DEF_H
#define SCI_ENUM_DEF_H

#include "sim\_sim_enum_def.h"

//! SCI classes available via SCI_API interface
enum sci_mod
{
  SCI_BASE = 0,
  SCI_FIR = 1,
  SCI_FIR_X = 2,
  SCI_LFSR = 3,
  SCI_COUNTER = 4,
  SCI_LSR = 5,
  SCI_BERT = 6,
  SCI_QAM_MOD = 7,
  SCI_QAM_DEM = 8,
  SCI_BIN2INT = 9,
  SCI_INT2BIN = 10,
  SCI_RMS = 11,
  SCI_RMS_X = 12,
  SCI_WGN = 13,
  SCI_WGN_X = 14,
  SCI_FIR_UP = 15,
  SCI_FIR_UP_X = 16,
  SCI_AMP = 17,
  SCI_AMP_X = 18,
  SCI_MIX = 19,
  SCI_MIX_X = 20,
  SCI_NCO = 21,
  SCI_VCO = 22,
  SCI_EJP = 23,
  SCI_AP2IQ = 24,
  SCI_IQ2AP = 25,
  SCI_CIRCBUFF = 26,
  SCI_CIRCBUFF_X = 27,
  SCI_PSK_MOD = 28,
  SCI_PSK_DEM = 29,
  SCI_SRC = 30,
  SCI_SRC_X = 31,
  SCI_CASDEC_X = 32,
  SCI_COFDM_MOD = 33,
  SCI_COFDM_DEM = 34,
  SCI_COFDM_MAP = 35,
  SCI_COFDM_DEMAP = 36,
  SCI_COFDM_SEL = 37,
  SCI_BINBUFF = 38,
  SCI_PAM_MOD = 39,
  SCI_PAM_DEM = 40,
  SCI_TEDG_X = 41
};

//! SCI get()/set() function parameters
enum sci_par
{
  SCI_TYPE = 0,
  SCI_SIZE = 1,
  SCI_OUTPUT = 2,
  SCI_STATE = 3,
  SCI_TAPS = 4,
  SCI_PARAM_N = 5,
  SCI_PARAM_M = 6,
  SCI_SYMBOL_SIZE = 7,
  SCI_RESET_STATE = 8,
  SCI_PRBS = 9,
  SCI_LENGTH = 10,
  SCI_THRESHOLD = 11,
  SCI_FSM = 12,
  SCI_ADR = 13,
  SCI_CNT = 14,
  SCI_ACC_CNT = 15,
  SCI_METRICS = 16,
  SCI_SCALE = 17,
  SCI_MSB_FLAG = 18,
  SCI_SIGMA = 19,
  SCI_MEAN = 20,
  SCI_GAIN = 21,
  SCI_OFFSET = 22,
  SCI_ACC = 23,
  SCI_VEC = 24,
  SCI_PEEK_VEC = 25,
  SCI_PEEK_REV_VEC = 26,
  SCI_N_OF_ELEM = 27,
  SCI_WIN_TYPE = 28,
  SCI_ORDER = 29,
  SCI_COFDM_NFFT = 30,
  SCI_COFDM_CP = 31,
  SCI_COFDM_QAM_SIZE = 32,
  SCI_COFDM_PA = 33,
  SCI_COFDM_DATA_INDEXES = 34,
  SCI_COFDM_PILOT_INDEXES = 35,
  SCI_COFDM_ZERO_INDEXES = 36,
  SCI_COFDM_SEL_INDEXES = 37,
  SCI_COFDM_DATA = 38,
  SCI_COFDM_PILOTS = 39,
  SCI_COFDM_CARRIERS = 40,
  SCI_COFDM_SYMBOL = 41,
  SCI_COFDM_SEL_CARRIERS = 42,
  SCI_REVERSE_FLAG = 43,
  SCI_POLY = 44,
  SCI_SINGLETON = 45,
  SCI_RATE = 46,
  SCI_MODE = 47,
  SCI_QUANT = 48
};

//! SCI exec() commands
enum sci_com
{
  SCI_TEST = 0,
  SCI_RESET = 1,
  SCI_START = 2,
  SCI_CLEAR = 3,
};

//! SCI error codes
enum sci_err
{
  SCI_ERR_OK = 0,
  SCI_ERR_UNKNOWN_MOD = 1,
  SCI_ERR_UNKNOWN_PARA = 2,
  SCI_ERR_UNKNOWN_COMD = 3,
  SCI_ERR_NULL_VECT = 4,
  SCI_ERR_BAD_VAR_TYPE = 5,
  SCI_ERR_CSCI = 6,
};


#endif
