/*!
* \brief -  sci_error class
* \author maki
*/

#ifndef SCI_EXCEPTION_HPP
#define SCI_EXCEPTION_HPP

#include <stdexcept>

class sci_exception : public std::runtime_error
{
  int info_;
  char *msg_;
public:

  sci_exception(char * msg, int info): std::runtime_error(msg), msg_(msg) , info_(info) {};
  sci_exception(char * msg): std::runtime_error(msg), msg_(msg)
  {
    info_ = 0;
  };
  sci_exception(): std::runtime_error("Unknown Error")
  {
    msg_ = "Unknown Error";
    info_ = -1;
  };

  int get_info() const
  {
    return info_;
  };
  const char* get_msg()
  {
    return msg_;
  };

};

#endif