/*xxx
* \brief - second layer of sci interface
* Function headers use only C style - no c++, itpp
* \author maki
*/

// this is included both in *.c and *.cpp
// extern "C" is not understand by c-compiler

// stack is a stack in scicoslab, scilab,... domain

#include "_sci_if_var_struct.h"

#ifdef __cplusplus
extern "C" {
#endif

#ifndef SCI_IF_CPP_H
#define SCI_IF_CPP_H

#define SCI_ERR_MSG_LEN 1024

// error setting function
  void sci_if_err_set(int e);
// error message setting function
  void sci_if_err_msg_set(const char *p_msg);
// info setting function
  void sci_if_info_set(int i);

//! copy data from c++ heap into the stack
  void sci_if_copy_var(struct var_struct *p_s_v);
//! delete object at c++ heap
  void sci_if_delete_var(struct var_struct *p_s_v);

//! interface between sci_cpp and sci_stack
  void * sci_if_create(int mod);
//! interface between sci_cpp and sci_stack
  void sci_if_set(void *p_sci, int param, struct var_struct  *p_s_v);
//! interface between sci_cpp and sci_stack
  struct var_struct sci_if_get(void *p_sci, int param);
//! interface between sci_cpp and sci_stack
  void sci_if_exec(void *p_sci, int command);
//! interface between sci_cpp and sci_stack
  struct var_struct sci_if_gen(void *p_sci, struct var_struct* p_s_ce);
//! interface between sci_cpp and sci_stack
  struct var_struct sci_if_proc(void *p_sci, struct var_struct* p_s_ce, struct var_struct* p_s_x);
//! interface between sci_cpp and sci_stack
  void sci_if_destroy(void *p_sci);


#endif // #ifndef SCI_IFCPP_H

#ifdef __cplusplus
}
#endif
