/*xxx
* \brief - interface functions to sci_base - abstraction layer class
* \author maki
*/

#ifndef SCI_CREATE_VAR_HPP
#define SCI_CREATE_VAR_HPP

#include "_sci_if_var_struct.h"
#include "sci\_sci_types.h"

using namespace SCI;

//! return struct with fields set by object methods
struct var_struct var_to_struct(sci_var *p_v);

// create new var object using var_struct descriptor
sci_var* create_var(struct var_struct *p_s_v);

// upload data from c++ into external stack - all data are about source and destination are in p_s_v
void push(struct var_struct *p_s_v);

inline void push(struct var_struct *p_s_v, sci_var_double *p_sci_var);
inline void push(struct var_struct *p_s_v, sci_var_int *p_sci_var);
inline void push(struct var_struct *p_s_v, sci_var_bool *p_sci_var);
inline void push(struct var_struct *p_s_v, sci_var_complex *p_sci_var);

inline void push(struct var_struct *p_s_v, sci_var_vec *p_sci_var);
inline void push(struct var_struct *p_s_v, sci_var_ivec *p_sci_var);
inline void push(struct var_struct *p_s_v, sci_var_bvec *p_sci_var);
inline void push(struct var_struct *p_s_v, sci_var_cvec *p_sci_var);

inline void push(struct var_struct *p_s_v, sci_var_mat *p_sci_var);
inline void push(struct var_struct *p_s_v, sci_var_imat *p_sci_var);
inline void push(struct var_struct *p_s_v, sci_var_bmat *p_sci_var);
inline void push(struct var_struct *p_s_v, sci_var_cmat *p_sci_var);

// download data from external stack into c++ - all data are about source and destination are in p_s_v
void pop(struct var_struct *p_s_v);

inline void pop(struct var_struct *p_s_v, sci_var_double *p_sci_var);
inline void pop(struct var_struct *p_s_v, sci_var_int *p_sci_var);
inline void pop(struct var_struct *p_s_v, sci_var_bool *p_sci_var);
inline void pop(struct var_struct *p_s_v, sci_var_complex *p_sci_var);

inline void pop(struct var_struct *p_s_v, sci_var_vec *p_sci_var);
inline void pop(struct var_struct *p_s_v, sci_var_ivec *p_sci_var);
inline void pop(struct var_struct *p_s_v, sci_var_bvec *p_sci_var);
inline void pop(struct var_struct *p_s_v, sci_var_cvec *p_sci_var);

inline void pop(struct var_struct *p_s_v, sci_var_mat *p_sci_var);
inline void pop(struct var_struct *p_s_v, sci_var_imat *p_sci_var);
inline void pop(struct var_struct *p_s_v, sci_var_bmat *p_sci_var);
inline void pop(struct var_struct *p_s_v, sci_var_cmat *p_sci_var);


#endif