/*xxx
 * \author maki
 */
#ifndef SCI_IF_EMU_HPP
#define SCI_IF_EMU_HPP

#include "sci\_sci_base.hpp"
#include "sci\_sci_macros.hpp"
#include "sci\_sci_var.hpp"
#include "sci\_sci_if_create_var.hpp"
#include "sci\_sci_if_emu_var_struct.hpp"
#include "sci\_sci_emu.hpp"

#include "_sci_if_var_struct.h"

#define nFAST_EMU

namespace SCI
{
/// \cond EMU_DOC
/// this should prevent doxygen from documenting functions below

// simulate a struct var_struct using double
struct var_struct	emu_var_struct(const double &v);
// simulate a struct var_struct using vec
struct var_struct	emu_var_struct(const vec &v);
// simulate a struct var_struct using mat
struct var_struct	emu_var_struct(const mat &m);

// simulate a struct var_struct using int
struct var_struct	emu_var_struct(const int &v);
// simulate a struct var_struct using ivec
struct var_struct	emu_var_struct(const ivec &v);
// simulate a struct var_struct using imat
struct var_struct	emu_var_struct(const imat &m);

// simulate a struct var_struct using int
struct var_struct	emu_var_struct(const bool &v);
// simulate a struct var_struct using bvec
struct var_struct	emu_var_struct(const bvec &v);
// simulate a struct var_struct using bmat
struct var_struct	emu_var_struct(const bmat &m);

// simulate a struct var_struct using complex
struct var_struct	emu_var_struct(const std::complex<double> &v);
// simulate a struct var_struct using cvec
struct var_struct	emu_var_struct(const cvec &v);
// simulate a struct var_struct using cmat
struct var_struct	emu_var_struct(const cmat &m);

// no overload just keep function name conventions
void* EMU_SCI_IF_CREATE(int sci_type);

// no overload just keep function name conventions
void EMU_SCI_IF_EXEC(void *p_dev, int sci_command);

// no overload just keep function name conventions
void EMU_SCI_IF_DESTROY(void *p_dev);

template <class P >
void EMU_SCI_IF_SET(void *p_dev, int sci_param, P param)
{
  struct var_struct s_v;

  // create an external variable using param
  s_v = emu_var_struct(param);
  // call if api function
  sci_if_set(p_dev, sci_param, &s_v);
  // remove data allocated by emu_var_struct
  delete_emu_var_struct_data(&s_v);
}

template <class P >
P EMU_SCI_IF_GET(void *p_dev, int sci_param)
{
  struct var_struct s_v;
  P v;

  // sci_var variable is created and there is a description of it in s_v
  s_v = sci_if_get(p_dev, sci_param);
#if defined (FAST_EMU)
  // be fast -  not accurate - don't test upload
  sci_var_value_get((sci_var *)(s_v.p_var), &v);
  sci_if_delete_var(&s_v);
#else
  // be inefficient
  // allocate memory for external variable using struct_var, copy sci_var to external, delete sci_var created by sci_if_get() as gateway
  // fetch external data into temporary sci_var, extract returned object, delete external data and temporary sci_var
  sci_var *p_var_v;

  emu_sci_if_malloc(&s_v);
  // use gateway functions to upload data to emulated external memory
  sci_if_copy_var(&s_v);
  // delete sci_var created by sci_if_get(), since return variable is copied by sci_if_copy_var(), yet in stack format
  sci_if_delete_var(&s_v);
  // get data in stack format back into c++ as a sci_var object
  p_var_v = create_var(&s_v);
  // store value in returned object
  sci_var_value_get(p_var_v, &v);
  // delete stack data
  delete_emu_var_struct_data(&s_v);
  // delete sci_var as return is now safe in y
  delete(p_var_v);
#endif

  return (v);

}

template <class Y, class CE>
Y EMU_SCI_IF_GEN(void *p_dev, CE v_ce)
{
  Y y;
  struct var_struct s_y, s_ce;

  s_ce = emu_var_struct(v_ce);
  s_y = sci_if_gen(p_dev, &s_ce);
  delete_emu_var_struct_data(&s_ce); // emu creates data directly on heap
#if defined (FAST_EMU)
  // be fast -  not accurate - don't test upload
  sci_var_value_get((sci_var *)(s_y.p_var), &y);
  sci_if_delete_var(&s_y);
#else
  // be inefficient
  // allocate memory for external variable using struct_var, copy sci_var to external, delete sci_var created by sci_if_get() as gateway
  // fetch external data into temporary sci_var, extract returned object, delete external data and temporary sci_var

  sci_var *p_var_y;

  // allocate memory for external variable using struct_var
  emu_sci_if_malloc(&s_y);
  // use gateway functions to upload data to emulated external memory
  sci_if_copy_var(&s_y);
  // delete sci_var created by sci_if_get(), since return variable is copied by sci_if_copy_var(), yet in stack format
  sci_if_delete_var(&s_y);
  // get data in stack format back into c++ as a sci_var object
  p_var_y = create_var(&s_y);
  // get what is to be returned in y
  sci_var_value_get(p_var_y, &y);
  // delete stack data
  delete_emu_var_struct_data(&s_y);
  // delete sci_var as return variable is now safe in y
  delete(p_var_y);
#endif

  return (y);
}

template <class Y, class CE, class X>
Y EMU_SCI_IF_PROC(void *p_dev, CE v_ce, X v_x)
{
  Y y;
  struct var_struct s_y, s_ce, s_x;

  s_ce = emu_var_struct(v_ce);
  s_x = emu_var_struct(v_x);
  s_y = sci_if_proc(p_dev, &s_ce, &s_x);
  delete_emu_var_struct_data(&s_ce); // emu creates data directly on heap
  delete_emu_var_struct_data(&s_x);  // emu creates data directly on heap
#if defined (FAST_EMU)
  // be fast -  not accurate - don't test upload
  sci_var_value_get((sci_var *)(s_y.p_var), &y);
  sci_if_delete_var(&s_y);
#else
  // be inefficient
  // allocate memory for external variable using struct_var, copy sci_var to external, delete sci_var created by sci_if_get() as gateway
  // fetch external data into temporary sci_var, extract returned object, delete external data and temporary sci_var

  sci_var *p_var_y;

  //allocate memory for external variable using struct_var
  emu_sci_if_malloc(&s_y);
  //use gateway functions to upload data to emulated external memory
  sci_if_copy_var(&s_y);
  //delete sci_var created by sci_if_get(), since return variable is copied by sci_if_copy_var(), yet in stack format
  sci_if_delete_var(&s_y);
  //get data in stack format back into c++ as a sci_var object
  p_var_y = create_var(&s_y);
  // get what is to be returned in y
  sci_var_value_get(p_var_y, &y);
  // delete stack data
  delete_emu_var_struct_data(&s_y);
  // delete sci_var as return is now safe in y
  delete(p_var_y);
#endif

  return (y);
}

/// end of condition preventing doxygen from documenting classes
/// \endcond

}

#endif
