/*xxx
* \brief - define stack - it++ conversion operators - implementation is target dependent
* \author maki
*/

#ifndef SCI_PUSH_OP_HPP
#define SCI_PUSH_OP_HPP

#include <itpp\itbase.h>
#include "_sci_if_var_struct.h"

#define C_OFFSET(i,j,ROWS,COLS)  (j+i*(COLS))
#define F_OFFSET(i,j,ROWS,COLS)  (i+j*(ROWS))

using namespace itpp;
using namespace std;

/*
you can't implement this
//! vec <= p_var_struct;  copy var_struct to vec
void operator <=(double &v, var_struct *p_sci);
//! p_var_struct <= vec; copy vec to var_struct
void operator <=(var_struct *p_sci, const double &v);
- both operand are considered to be standard type
*/

void push_to_ext_stack(var_struct *p_sci, const double &v);
void push_to_ext_stack(var_struct *p_sci, const complex<double> &v);
void push_to_ext_stack(var_struct *p_sci, const int &v);
void push_to_ext_stack(var_struct *p_sci, const bool &v);

void pop_from_ext_stack(double &v, const var_struct *p_sci);
void pop_from_ext_stack(complex<double> &v, const var_struct *p_sci);
void pop_from_ext_stack(int &v, const var_struct *p_sci);
void pop_from_ext_stack(bool &v, const var_struct *p_sci);


// vec <= p_var_struct;  copy var_struct to vec
void operator <=(vec &v, var_struct *p_sci);
// p_var_struct <= vec; copy vec to var_struct
void operator <=(var_struct *p_sci, const vec &v);

// ivec <= p_sci; copy var_struct to ivec
void operator <=(ivec &iv, var_struct *p_sci);
// p_sci <= ivec; copy ivec to var_struct
void operator <=(var_struct *p_sci, const ivec &iv);

// bvec <= p_sci; copy var_struct to bvec
void operator <=(bvec &b, var_struct *p_sci);
// p_sci <= bvec; copy bvec to var_struct
void operator <=(var_struct *p_sci, const bvec &b);

// cvec <= p_var_struct; ; copy var_struct to cvec
void operator <=(cvec &cv, var_struct *p_sci);
// p_var_struct <= cvec ; copy vec to sci
void operator <=(var_struct *p_sci, const cvec &cv);

// mat <= p_sci; copy sci_mat to mat
void operator <=(mat &m, var_struct *p_sci);
// p_sci <= mat; copy mat to sci_mat
void operator <=(var_struct *p_sci, const mat &m);

// imat <= p_sci; copy var_struct to imat
void operator <=(imat &m, var_struct *p_sci);
// p_sci <= mat; copy imat to var_struct
void operator <=(var_struct *p_sci, const imat &m);

// bmat <= p_sci; copy var_struct to mat
void operator <=(bmat &m, var_struct *p_sci);
// p_sci <= bat; copy bmat to var_struct
void operator <=(var_struct *p_sci, const bmat &m);

// cmat <= p_sci; copy var_struct to cmat
void operator <=(cmat &cm, var_struct *p_sci);
// p_sci <= mat; copy cmat to var_struct
void operator <=(var_struct *p_sci, const cmat &cm);

#endif