/*!
* \brief - macros for testing sci layer and sci_if with SCILAB PSEUDO CODE
* \author maki
*/

#ifndef SCI_MACROS_HPP
#define SCI_MACROS_HPP

#if defined(SCI_LIB_MACROS)

#include "sci\_sci_api.hpp"
#include "sci\_sci_emu.hpp"

#define SCI_NAMESPACE           "SCI"

#define SCI_CREATE              EMU_SCI_CREATE
#define SCI_SET                 EMU_SCI_SET
#define SCI_GET                 EMU_SCI_GET
#define SCI_EXEC                EMU_SCI_EXEC
#define SCI_GEN                 EMU_SCI_GEN
#define SCI_PROC                EMU_SCI_PROC
#define SCI_DESTROY             EMU_SCI_DESTROY

#elif defined ( SCI_DLL_MACROS )

#include "sci\_sci_api_dll.hpp"
#include "sci\_sci_emu.hpp"

#define SCI_NAMESPACE           "SCI_DLL"

extern pf_sci_create            sci_create;
extern pf_sci_set               sci_set;
extern pf_sci_get               sci_get;
extern pf_sci_exec              sci_exec;
extern pf_sci_gen               sci_gen;
extern pf_sci_proc              sci_proc;
extern pf_sci_destroy           sci_destroy;

#define SCI_CREATE              EMU_SCI_CREATE
#define SCI_SET                 EMU_SCI_SET
#define SCI_GET                 EMU_SCI_GET
#define SCI_EXEC                EMU_SCI_EXEC
#define SCI_GEN                 EMU_SCI_GEN
#define SCI_PROC                EMU_SCI_PROC
#define SCI_DESTROY             EMU_SCI_DESTROY


#elif defined( SCI_IF_LIB_MACROS )

#include "_sci_if.h"
#include "sci\_sci_if_emu.hpp"

#define SCI_CREATE            EMU_SCI_IF_CREATE
#define SCI_SET               EMU_SCI_IF_SET
#define SCI_GET               EMU_SCI_IF_GET
#define SCI_EXEC              EMU_SCI_IF_EXEC
#define SCI_GEN               EMU_SCI_IF_GEN
#define SCI_PROC              EMU_SCI_IF_PROC
#define SCI_DESTROY           EMU_SCI_IF_DESTROY

#endif

#endif // SCI_MACROS_HPP