/*xxx
* \brief - definition of scilab sci_var class and derived classes
* \author maki
*/

#ifndef SCI_SCI_VAR_HPP
#define SCI_SCI_VAR_HPP

// ---- ITPP  ----
#include "itpp\itbase.h"
#include "sci\_sci_types.h"

using namespace std;
using namespace itpp;

namespace SCI
{

/*!
 * \class sci_var
 * \brief  Abstract base for encapsulation of sci_variables
 */
class sci_var
{
public:

  virtual ~sci_var(void)
  {
  };

  virtual int                 get_sci_type() = 0;
  virtual int                 get_rows() = 0;
  virtual int                 get_cols() = 0;

  virtual bool                get_bool() = 0;
  virtual bvec                get_bvec() = 0;
  virtual bmat                get_bmat() = 0;

  virtual int                 get_int() = 0;
  virtual ivec                get_ivec() = 0;
  virtual imat                get_imat() = 0;

  virtual double              get_double() = 0;
  virtual vec                 get_vec() = 0;
  virtual mat                 get_mat() = 0;

  virtual complex<double>     get_complex() = 0;
  virtual cvec                get_cvec() = 0;
  virtual cmat                get_cmat() = 0;
};

/// \cond SCI_VAR_DOC
/// this should prevent doxygen from documenting classes below
class sci_var_double : public sci_var
{

public:
  double v;

  sci_var_double()
  {
    return;
  };

  sci_var_double(double x)
  {
    v = x;
    return;
  };

  virtual ~sci_var_double(void)
  {
  };

  virtual int get_sci_type()
  {
    return SCI_TYPE_DOUBLE;
  }

  int get_rows()
  {
    return (1);
  }

  int get_cols()
  {
    return (1);
  }


  // default
  virtual double              get_double();
  // available if defined(SCI_FLEX)
  virtual int                 get_int();
  virtual bool                get_bool();

  // not available
  virtual vec                 get_vec();
  virtual bvec                get_bvec();
  virtual ivec                get_ivec();
  virtual cvec                get_cvec();

  virtual mat                 get_mat();
  virtual imat                get_imat();
  virtual bmat                get_bmat();
  virtual complex<double>     get_complex();
  virtual cmat                get_cmat();

};

class sci_var_int : public sci_var
{

public:
  int v;

  sci_var_int()
  {
    return;
  };

  sci_var_int(int x)
  {
    v = x;
    return;
  };

  virtual ~sci_var_int(void)
  {
  };

  virtual int get_sci_type()
  {
    return SCI_TYPE_INT;
  }

  int get_rows()
  {
    return (1);
  }

  int get_cols()
  {
    return (1);
  }

  // default
  virtual int                 get_int();

  // available if defined(SCI_FLEX)
  virtual bool                get_bool();

  // not available
  virtual double              get_double();
  virtual complex<double>     get_complex();

  virtual vec                 get_vec();
  virtual bvec                get_bvec();
  virtual ivec                get_ivec();
  virtual cvec                get_cvec();

  virtual mat                 get_mat();
  virtual imat                get_imat();
  virtual bmat                get_bmat();
  virtual cmat                get_cmat();

};


class sci_var_bool : public sci_var
{

public:
  bool v;

  sci_var_bool()
  {
    return;
  };

  sci_var_bool(bool x)
  {
    v = x;
    return;
  };

  virtual ~sci_var_bool(void)
  {
  };

  virtual int get_sci_type()
  {
    return SCI_TYPE_BOOL;
  }

  int get_rows()
  {
    return (1);
  }

  int get_cols()
  {
    return (1);
  }

  // default
  virtual bool                 get_bool();

  // available if defined(SCI_FLEX)

  // not available
  virtual double              get_double();
  virtual int                 get_int();
  virtual complex<double>     get_complex();

  virtual vec                 get_vec();
  virtual bvec                get_bvec();
  virtual ivec                get_ivec();
  virtual cvec                get_cvec();

  virtual mat                 get_mat();
  virtual imat                get_imat();
  virtual bmat                get_bmat();
  virtual cmat                get_cmat();

};

class sci_var_complex : public sci_var
{

public:
  complex<double> v;

  sci_var_complex()
  {
    return;
  };

  sci_var_complex(complex<double> x)
  {
    v = x;
    return;
  };

  virtual ~sci_var_complex(void)
  {
  };

  virtual int get_sci_type()
  {
    return SCI_TYPE_COMPLEX;
  }

  int get_rows()
  {
    return (1);
  }

  int get_cols()
  {
    return (1);
  }

  // default
  virtual complex<double>     get_complex();
  // available if defined(SCI_FLEX)

  // not available
  virtual double              get_double();
  virtual int                 get_int();
  virtual bool                get_bool();

  virtual vec                 get_vec();
  virtual bvec                get_bvec();
  virtual ivec                get_ivec();
  virtual cvec                get_cvec();

  virtual mat                 get_mat();
  virtual imat                get_imat();
  virtual bmat                get_bmat();
  virtual cmat                get_cmat();

};

class sci_var_vec: public sci_var
{

public:
  vec v;

  sci_var_vec()
  {
    return;
  };

  sci_var_vec(vec vector)
  {
    v = vector;
    return;
  };

  virtual ~sci_var_vec(void)
  {
  };

  virtual int get_sci_type()
  {
    return SCI_TYPE_VEC;
  }

  int get_rows()
  {
    return (v.length());
  }

  int get_cols()
  {
    return (1);
  }

  // default
  virtual double              get_double();
  virtual vec                 get_vec();
  // available if defined(SCI_FLEX)
  virtual bool                get_bool();
  virtual bvec                get_bvec();
  virtual int                 get_int();
  virtual ivec                get_ivec();
  // not available
  virtual mat                 get_mat();
  virtual imat                get_imat();
  virtual bmat                get_bmat();
  virtual complex<double>     get_complex();
  virtual cvec                get_cvec();
  virtual cmat                get_cmat();

};

class sci_var_mat: public sci_var
{
public:
  mat v;

  sci_var_mat()
  {
    return;
  };

  sci_var_mat(mat matrix)
  {
    v = matrix;
    return;
  };

  virtual ~sci_var_mat(void)
  {
  };

  virtual int get_sci_type()
  {
    return SCI_TYPE_MAT;
  }

  int get_rows()
  {
    return (v.rows());
  }

  int get_cols()
  {
    return (v.cols());
  }

  // default
  virtual double              get_double();
  virtual vec                 get_vec();
  virtual mat                 get_mat();
  // available if defined(SCI_FLEX)
  virtual bool                get_bool();
  virtual bvec                get_bvec();
  virtual bmat                get_bmat();
  virtual int                 get_int();
  virtual ivec                get_ivec();
  virtual imat                get_imat();
  // not available
  virtual complex<double>     get_complex();
  virtual cvec                get_cvec();
  virtual cmat                get_cmat();

};

class sci_var_ivec: public sci_var
{
public:
  itpp::ivec v;

  sci_var_ivec()
  {
    return;
  };

  sci_var_ivec(ivec vector)
  {
    v = vector;
    return;
  };

  virtual ~sci_var_ivec(void)
  {
  };

  virtual int get_sci_type()
  {
    return SCI_TYPE_IVEC;
  }

  int get_rows()
  {
    return (v.length());
  }

  int get_cols()
  {
    return (1);
  }

  // default
  virtual int                 get_int();
  virtual ivec                get_ivec();
  // available if defined(SCI_FLEX)
  virtual bool                get_bool();
  virtual bvec                get_bvec();
  // not available
  virtual bmat                get_bmat();
  virtual imat                get_imat();
  virtual double              get_double();
  virtual vec                 get_vec();
  virtual mat                 get_mat();
  virtual complex<double>     get_complex();
  virtual cvec                get_cvec();
  virtual cmat                get_cmat();

};

class sci_var_imat: public sci_var
{
public:
  itpp::imat v;

  sci_var_imat()
  {
    return;
  };

  sci_var_imat(imat matrix)
  {
    v = matrix;
    return;
  };

  virtual ~sci_var_imat(void)
  {
  };

  virtual int get_sci_type()
  {
    return SCI_TYPE_IMAT;
  }

  int get_rows()
  {
    return (v.rows());
  }

  int get_cols()
  {
    return (v.cols());
  }

  // default
  virtual int                 get_int();
  virtual ivec                get_ivec();
  virtual imat                get_imat();
  // available if defined(SCI_FLEX)
  virtual bool                get_bool();
  virtual bvec                get_bvec();
  virtual bmat                get_bmat();
  // not available
  virtual double              get_double();
  virtual vec                 get_vec();
  virtual mat                 get_mat();
  virtual complex<double>     get_complex();
  virtual cvec                get_cvec();
  virtual cmat                get_cmat();

};

class sci_var_bvec: public sci_var
{
public:
  itpp::bvec v;

  sci_var_bvec()
  {
    return;
  };

  sci_var_bvec(bvec vector)
  {
    v = vector;
    return;
  };

  virtual ~sci_var_bvec(void)
  {
  };

  virtual int get_sci_type()
  {
    return SCI_TYPE_BVEC;
  }

  int get_rows()
  {
    return (v.length());
  }

  int get_cols()
  {
    return (1);
  }

  // default
  virtual bool                get_bool();
  virtual bvec                get_bvec();

  // not available
  virtual bmat                get_bmat();
  virtual int                 get_int();
  virtual ivec                get_ivec();
  virtual imat                get_imat();
  virtual double              get_double();
  virtual vec                 get_vec();
  virtual mat                 get_mat();
  virtual complex<double>     get_complex();
  virtual cvec                get_cvec();
  virtual cmat                get_cmat();


};

class sci_var_bmat: public sci_var
{
public:
  itpp::bmat v;

  sci_var_bmat()
  {
    return;
  };

  sci_var_bmat(bmat matrix)
  {
    v = matrix;
    return;
  };

  virtual ~sci_var_bmat(void)
  {
  };

  virtual int get_sci_type()
  {
    return SCI_TYPE_BMAT;
  }

  int get_rows()
  {
    return (v.rows());
  }

  int get_cols()
  {
    return (v.cols());
  }


  // default
  virtual bool                get_bool();
  virtual bvec                get_bvec();
  virtual bmat                get_bmat();

  // not available
  virtual int                 get_int();
  virtual ivec                get_ivec();
  virtual imat                get_imat();

  virtual double              get_double();
  virtual vec                 get_vec();
  virtual mat                 get_mat();

  virtual complex<double>     get_complex();
  virtual cvec                get_cvec();
  virtual cmat                get_cmat();

};

class sci_var_cvec: public sci_var
{
public:
  itpp::cvec v;

  sci_var_cvec()
  {
    return;
  };

  sci_var_cvec(cvec vector)
  {
    v = vector;
    return;
  };

  virtual ~sci_var_cvec(void)
  {
  };

  virtual int get_sci_type()
  {
    return SCI_TYPE_CVEC;
  }

  int get_rows()
  {
    return (v.length());
  }

  int get_cols()
  {
    return (1);
  }

  // default
  virtual complex<double>     get_complex();
  virtual cvec                get_cvec();

  // not available
  virtual cmat                get_cmat();
  virtual bool                get_bool();
  virtual bvec                get_bvec();
  virtual bmat                get_bmat();
  virtual int                 get_int();
  virtual ivec                get_ivec();
  virtual imat                get_imat();
  virtual double              get_double();
  virtual vec                 get_vec();
  virtual mat                 get_mat();

};

class sci_var_cmat: public sci_var
{
public:
  itpp::cmat v;

  sci_var_cmat()
  {
    return;
  };


  sci_var_cmat(cmat matrix)
  {
    v = matrix;
    return;
  };

  virtual ~sci_var_cmat(void)
  {
  };

  virtual int get_sci_type()
  {
    return SCI_TYPE_CMAT;
  }

  int get_rows()
  {
    return (v.rows());
  }

  int get_cols()
  {
    return (v.cols());
  }

  virtual complex<double>     get_complex();
  virtual cvec                get_cvec();
  virtual cmat                get_cmat();

  virtual bool                get_bool();
  virtual bvec                get_bvec();
  virtual bmat                get_bmat();

  virtual int                 get_int();
  virtual ivec                get_ivec();
  virtual imat                get_imat();

  virtual double              get_double();
  virtual vec                 get_vec();
  virtual mat                 get_mat();

};
/// end of condition preventing doxygen from documenting classes
/// \endcond

}

#endif
