/*xxx
* \brief - define sci_var struct
* \author maki
*/

#ifdef __cplusplus
extern "C" {
#endif


#ifndef SCI_IF_VAR_STRUCT_H
#define SCI_IF_VAR_STRUCT_H

#define SCI_NAMESPACE           "SCILAB_IF"

  /*!
   * \struct var_struct
   * \brief definition of the variable on the target stack
   */

  struct var_struct_scilab
  {
    union                           // external data pointer
    {
      struct
      {
        double  *p_re;              // pointer to real part - typically double*, might be int*
        double  *p_im;              // pointer to imag part - typically double*,
      } re_im;
      int    *p_bool;               // pointer to bool
      double  *p_double;            // pointer to double
      int     *p_int;               // pointer to integer
    } p_external;

    int rows;                       // rows in matrix,  for scalar: 1
    int cols;                       // cols in matrix,  for scalar and vector: 1
    int sci_type;
    void *p_var;                    // pointer to matching variable object on c++ heap
  };

#define var_struct                  var_struct_scilab
typedef struct var_struct_scilab    var_struct_t;

#endif // #ifndef 

#ifdef __cplusplus
}
#endif
