/*
* \brief - define sci_var struct
* \author maki
*/

#ifdef __cplusplus
extern "C" {
#endif


#ifndef SCI_IF_VAR_STRUCT_H
#define SCI_IF_VAR_STRUCT_H

#define SCI_NAMESPACE           "SCIPY_IF"

// #include "stdbool.h" // only in msvc2013
#ifndef _STDBOOL
#define _STDBOOL
#define __bool_true_false_are_defined	1
#ifndef __cplusplus
#define bool	char
#define false	0
#define true	1
#endif /* __cplusplus */
#endif /* _STDBOOL */

  /*!
   * \struct var_struct
   * \brief definition of the variable on the target stack
   */

  struct var_struct_scipy
  {
    union           // external data pointer
    {
      void    *p_complex;         // pointer to complex - when available as a standard C-type (C99)
      bool    *p_bool;            // pointer to bool
      double  *p_double;          // pointer to double
      int     *p_int;             // pointer to integer
    } p_external;

    int rows;                     // rows in matrix,  for scalar: 1
    int cols;                     // cols in matrix,  for scalar and vector: 1
    int sci_type;
    void *p_var;                  // pointer to matching variable object on c++ heap
  };

#define var_struct                 var_struct_scipy
typedef struct var_struct_scipy    var_struct_t;

#endif // #ifndef 

#ifdef __cplusplus
}
#endif
