/*xxx
* \brief - definition of sim enumerated definitions
* \author maki
*/

#ifndef SIM_ENUM_DEF_H
#define SIM_ENUM_DEF_H

/// \anchor BERT_FSM
/// \name BERT_FSM
///@{
/*! states of bert internal FSM - auto transitions in SIM::bert::process()
 \n transitions are determined by threshold settings [T0,T1,T2]
 \n metrics is sum(xor(X,Y)) where X[0:N-1] is input fed LSR, Y[0:N-1] is PRBS fed LSR
 \n N should be greater or equal with PRBS size due setting state of PRBS LFSR in RELOAD state
*/
enum bert_fsm_state
{
  BERT_FSM_RESET = 0,     //!< static idle state - no auto transition
  BERT_FSM_RELOAD = 1,    //!< (after N bits shifted in X and PRBS<=X)->PRESET
  BERT_FSM_PRESET = 2,    //!< after N bits shifted (metrics > T2)->RELOD, (T1 < metrics < T2)->nSYNC, (metrics<T0)->SYNC
  BERT_FSM_nSYNC = 3,     //!< (metrics <=T0)->SYNC,   (metrics <=T0)->RELOD
  BERT_FSM_SYNC = 4       //!< (metrics >T1)->nSYNC
};
///@}

/// \anchor BERT_ADDR
/// \name BERT_ADDR
///@{
/*! \brief addresses of bert internal registers
\n used by SIM::bert.set_adr() for defining target register of SIM::bert.get_state()
*/
enum bert_adr
{
  BERT_ADR_LSRX = 0,  //!< X[0:N] LSR
  BERT_ADR_LSRY = 1,  //!< Y[0:N] LSR
  BERT_ADR_PRBS = 2   //!< PRBS[0:n] LFSR, size determined by PRBS index or poly, n<=N
};
///@}

enum win_type
{
  WIN_RECT = 0,
  WIN_HANNING = 1,
  WIN_KAISER_BESSEL = 2,
  WIN_FLAT_TOP = 3
};

enum tedg_mode
{
  TEDG_MODE_STD = 0,
  TEDG_MODE_EDGE = 1,
  TEDG_MODE_PUMP = 2
};

#endif