/*xxx
* \brief -  new math format
* \author maki
*/

#ifndef SIM_EXTENSION_HPP
#define SIM_EXTENSION_HPP
#include <complex>
#include "itpp/itbase.h"


typedef std::complex<double> 	complexd;

// for future use
// #include <itpp/itbase.h>
// typedef Vec<long long>         lvec;
// typedef Mat<long long>         lmat;

/**
  * \brief 8-bit fractional data type in 1.7 format.
  */
typedef int8_t q7_t;

/**
  * \brief 16-bit fractional data type in 1.15 format.
  */
typedef int16_t q15_t;

/**
  * \brief 32-bit fractional data type in 1.31 format.
  */
typedef int32_t q31_t;

/**
  * \brief 64-bit fractional data type in 1.63 format.
  */
typedef int64_t q63_t;

/**
  * \brief 32-bit floating-point type definition.
  */
typedef float float32_t;

/**
  * \brief 64-bit floating-point type definition.
  */
typedef double float64_t;

/**
  * \brief Clips Q63 to Q31 values.
  */
static inline q31_t clip_q63_to_q31(q63_t x)
{
  return ((q31_t)(x >> 32) != ((q31_t)x >> 31)) ? ((0x7FFFFFFF ^ ((q31_t)(x >> 63)))) : (q31_t)x;
}

/**
  * \brief Clips Q63 to Q15 values.
  */
static inline q15_t clip_q63_to_q15(q63_t x)
{
  return ((q31_t)(x >> 32) != ((q31_t)x >> 31)) ? ((0x7FFF ^ ((q15_t)(x >> 63)))) : (q15_t)(x >> 15);
}

/**
  * \brief Clips Q31 to Q7 values.
  */
static inline q7_t clip_q31_to_q7(q31_t x)
{
  return ((q31_t)(x >> 24) != ((q31_t)x >> 23)) ? ((0x7F ^ ((q7_t)(x >> 31)))) : (q7_t)x;
}

/**
  * \brief Clips Q31 to Q15 values.
  */
static inline q15_t clip_q31_to_q15(q31_t x)
{
  return ((q31_t)(x >> 16) != ((q31_t)x >> 15)) ? ((0x7FFF ^ ((q15_t)(x >> 31)))) : (q15_t)x;
}

/**
  * \brief Multiplies 32 X 64 and returns 32 bit result in 2.30 format.
  */
static inline q63_t mult32x64(q63_t x, q31_t y)
{
  return ((((q63_t)(x & 0x00000000FFFFFFFF) * y) >> 32) + (((q63_t)(x >> 32) * y)));
}

static inline q31_t __SSAT(q31_t x, uint32_t y)
{
  int32_t posMax, negMin;
  uint32_t i;

  posMax = 1;
  for(i = 0; i < (y - 1); i++)
  {
    posMax = posMax * 2;
  }

  if(x > 0)
  {
    posMax = (posMax - 1);

    if(x > posMax)
    {
      x = posMax;
    }
  }
  else
  {
    negMin = -posMax;

    if(x < negMin)
    {
      x = negMin;
    }
  }
  return (x);

}



#endif