/*xxx
 * \brief - SIM::amp - gain block
 * \author maki
 */


#ifndef SIM_AMP_HPP
#define SIM_AMP_HPP

#include <itpp/itbase.h>

using namespace itpp;
using namespace std;

namespace SIM
{

/*!
 * \brief gain block with offset \n
 * Core function SIM::amp.process()\n
 * \details
 * y = gain*x+offset \n
 * default gain = 1.0 \n
 * default offset = 0.0 \n
 */

class amp
{
  double y0;
  double gain;
  double offset;

public:

  amp()
  {
    y0 = 0.0;
    gain = 1.0;
    offset = 0.0;
  };
  
  ~amp() 
  {
  };

  /*! set gain
  * \param [in] g - [double] gain
  */
  void set_gain(double g);
  
  /*! set offset
  * \param [in] o - [double] offset
  */
  void set_offset(double o);
  
  /*! set output value y0
  * \param [in] yout - [double] => y0
  */
  void set_output(double yout);

  /*! get gain
  * \return - [double] gain
  */
  double get_gain(void);
  
  /*! get offset value
  * \return - [double] offset
  */
  double get_offset(void);

  /*! get output value y0
  * \return - [double] y0
  */
  double get_output(void);

  /*! process input samples - [x] for active clock ticks [ce]
   * \param ce [bvec] clock_enable vector
   * \param  x [vec] input vector
   * \return y [vec] output vector y = gain*x + offset
  */
  vec process(const bvec &ce, const vec &x);
};

}	   // namespace SIM
#endif //SIM_AMP_HPP

