/*xxx
 * \brief - SIM::amp_x - complex gain block
 * \author maki
 */


#ifndef SIM_AMP_X_HPP
#define SIM_AMP_X_HPP

#include <complex>

#include <itpp/itbase.h>
#include "sim\_sim_extension.hpp"

using namespace itpp;
using namespace std;

namespace SIM
{

/*!
 * \brief complex gain block with offset \n
 * Core function SIM::amp_x.process() \n
 * \details
 * y = gain*x+offset \n
 * default gain = 1.0+j0.0 \n
 * default offset = 0.0+j0.0 \n
  */

class amp_x
{
  complexd y0;
  complexd gain;
  complexd offset;

public:

  amp_x()
  {
    y0 = complexd(0.0, 0.0);
    gain = complexd(1.0, 0.0);
    offset = complexd (0.0, 0.0);
  } ;

  ~amp_x() 
  {
  };

  /*! set gain
  * \param [in] g - [complex] gain
  */
  void set_gain(complexd g);

  /*! set offset
  * \param [in] o - [complex] offset
  */
  void set_offset(complexd o);

  /*! set output value y0
  * \param [in] yout - [complex] => y0
  */
  void set_output(complexd yout);

  /*! get gain
  * \return - [complex] gain
  */
  complexd get_gain(void);

  /*! get offset value
  * \return - [complex] offset
  */
  complexd get_offset(void);
  
  /*! get output value y0
  * \return - [complex] y0
  */
  complexd get_output(void);

  /*! process input samples - [x] for active clock ticks [ce]
  * \param [in] ce [bvec] clock_enable vector
  * \param [in] x  [cvec] input vector
  * \return     y  [cvec] output vector y = gain*x + offset
  */
  cvec process(const bvec &ce, const cvec &x);
};

}	   // namespace SIM
#endif //SIM_AMP_X_HPP

