/*!
* \brief - SIM::ap2iq  - amplitude,phase to IQ converter
* \author maki
*/

#ifndef SIM_AP2IQ_HPP
#define SIM_AP2IQ_HPP

#include <complex>

#include <itpp/itbase.h>
#include "sim\_sim_extension.hpp"

using namespace itpp;
using namespace std;

namespace SIM
{

/*!
 * \brief amplitude,phase -> (i+jq) \n
 * Core function SIM::ap2iq.process() \n
 * \details (i+jq) = A*exp(j*phase)
 */

class ap2iq
{
public:
  complexd y0;

  ap2iq()
  {
    y0 = complexd(0.0, 0.0);
  };
  
  ~ap2iq() 
  {
  };

  /*! set output value y0
  * \param [in] yout - [complex] y0
  */
  void set_output(complexd yout);

  /*! get output value y0
  * \return - [complex] y0
  */
  complexd get_output(void);

  /*! process input samples - [x] for active clock ticks [ce]
  * \param [in] ce [bvec] clock_enable vector
  * \param [in] x  [mat] input vector [a,ph]
  * \return     y  [cvec] output vector y = [I+jQ]
  */
  cvec process(const bvec &ce, const mat &x);

};

}	   // namespace SIM
#endif //SIM_AP2IQ_HPP

