/*xxx
* \brief - SIM::bin2int - - SIM layer implementation of binary to integer converter
* \author maki
*/


#ifndef SIM_BIN2INT_HPP
#define SIM_BIN2INT_HPP

#include <itpp/itbase.h>

using namespace itpp;
using namespace std;

namespace SIM
{

/*!
 * \brief binary to integer converter \n
 * Core function SIM::bin2int.process() \n
 */
class bin2int
{
private:
  bool msb_first;		//!< x[0]=MSB - default
  int symbol_size;	//!< bits per ce - clock tick
  int y0;				    //!< y0 - output for ce=0

public:
  bin2int()
  {
    msb_first = true;
    y0 = 0;
  };

  ~bin2int()
  {
  };

  /*! set size of a symbol - number of columns for binary symbol
  \param [in] W - [int] size of a symbol
  */
  void set_symbol_size(int W);

  /*! set msb flag - x[0]=MSB
  \param [in] msb - [bool] flag
  */
  void set_msb_flag(bool msb);

  /*! sets initial/idle output symbol
  \param [in] yout - [int] y0 = yout
  */
  void set_output(int yout);

  /*! get size of a symbol - number of columns for binary symbol
  \return [int] size of a symbol W
  */
  int get_symbol_size();

  /*! get msb flag - x[0]=MSB
  \return   - [bool] msb flag - x[0]=MSB
  */
  bool get_msb_flag();

  /*! get initial/idle output symbol
  \return  - [int] y0
  */
  int get_output();

  /*! for active clock ticks ce[i] convert one binary input symbol x[i,:] into unsigned integer
  \param  ce - [bvec] - clock enable vector - sizeof(ce)=N
  \param  x - [bmat] - input symbols matrix - sizeof(x)=[N,W]
  \return y -  [ivec] - output symbols vector - sizeof(y)=N
  */
  ivec process(const bvec &ce, const bmat &x);

};

}
#endif //SIM
