/*xxx
* \brief - SIM::binbuff - binary circular buffer derived from itpp::Circular_Buffer<bin>
* \author maki
*/

#ifndef SIM_BINBUFF_HPP
#define SIM_BINBUFF_HPP

#include <itpp/itbase.h>
#include <itpp/itcomm.h>

using namespace itpp;
using namespace std;


namespace SIM
{

/*!
 * \brief binary circular buffer \n
 * Core functions SIM::binbuff.process(), SIM::binbuff.generate() \n
 * \details
 * itpp::Circular_Buffer<bin> derived class with clocked interface
 */
class binbuff : public itpp::Circular_Buffer<bin>
{
private:
  bvec y0;			        //!< y0 - output symbol 
  int symbol_size;      //!< symbol width - bits per get(), in generate() and process()

public:
  binbuff()  
  { 
  };
  
  ~binbuff() 
  { 
  };

  /*! set buffer size 
  * \param [in] m - buffer size - in bits
  */
  void set_size(int m);		

  /*! set symbol size
  * \param [in] w - symbol size - in bits
  */
  void set_symbol_size(int w);		// output symbol width - bits per get, in generate and process
  
  /*! set output value y0
  * \param [in] yout - [bvec] y0
  */
  void set_output(bvec yout);

  /*! get buffer size
  * \return - [int] buffer size in bits
  */
  int get_size();

  /*! get symbol size
  * \return - [int] symbol size in bits
  */
  int get_symbol_size();
  
  /*! get output value
  * \return - [bvec] y0
  */
  bvec get_output();

  /*! for active clock ticks [ce] fetch symbol and and put back into the buffer to make it circular \n
  *   if (ce)  {yout = get(); put(yout); \n
  *\param ce - [bvec] clock_enable vector
  *\return y - [vec]  binary symbols 
  */
  bmat generate(const bvec &ce);

  /*! for active input clock ticks ceio[i,0] put input symbol x[i,:]  \n
   *  if (ceio[i,0]) { put(x[i]) } \n
   *  for active output clock ticks ceio[i,1] update yout by fetching one symbol \n
   *  if (ceo[i]) { yout = get() } \n
   *\param ceio - bmat - [cei | ceo] clock_enable vector
   *\param x - bmat - cei = > put bvec = bmat(i);
   *\return y - bmat  ceo = > get bvec = buff(symbol_width);
  */
  bmat process(const bmat &ceio, const bmat &x);
};


}
#endif // SIM_BINBUFF_HPP
