/*!
* \brief - SIM::casdec_x - cascade of /2 complex decimators
* \author maki
*/


#ifndef SIM_CASDEC_X_HPP
#define SIM_CASDEC_X_HPP

#include <complex>

#include <itpp/itbase.h>
#include <itpp/comm/sequence.h>

#include "sim_fir_x.hpp"
#include "sim_counter.hpp"


using namespace itpp;
using namespace std;


namespace SIM
{

/*!
 * \brief single cell of casdec_x - /2 complex FIR decimator and /2 counter \n
 * Core function SIM::dec_cell_x.process() \n
 */
class dec_cell_x
{
  SIM::counter          cnt;   //!< /2 counter  
  SIM::fir_x            f_x;   //!< FIR decimator

public:

  dec_cell_x()
  {
    cnt.set_N(2);
    cnt.reset();
  };

  ~dec_cell_x()
  {
  };

  /*! set FIR coefficients
  \param [in] c - [cvec] FIR coefficients
  */
  void set_taps(cvec c);

  /*! reset FIR state and counter
  */
  void reset();

  /*! process input samples - [x] for active clock ticks [ce]
  * \param ce - bvec - clock enable vector
  * \param x -  cvec  - input sample vector
  * \return y - cmat  - [cvec|ceo] complex output sample vector|ce output 
  */
  cmat process(const bvec &ce, const cvec &x);

};

/*!
* \brief cascade of by 2 complex decimators \n
* Core function SIM::casdec_x.process() \n
*/
class casdec_x
{
  vector <dec_cell_x>   dec_cell_vec;           //!< vector of decimation cells
  int                   N;                      //!< number of cells N=log2(order)
  int                   output_cell_index;      //!< output cell, default is N set by order, changed by set_rate() 

public:

  casdec_x()
  {
    N = 0;
    output_cell_index = 0;
  };

  ~casdec_x()
  {
  };

  /*! set order 2^N = k - where N is number of decimators
  \param [in] k decimator order 2^N 
  */
  void set_decimator_order(int k);

  /*! set rate 2^n = r - default rate is 2^N - where 
  \param [in] r decimator rate r= 2^n,  n <= N number of decimators 
  */
  void set_decimator_rate(int r);
  
  /*! set FIR coefficients
  \param [in] c - [cvec] FIR coefficients
  */
  void set_taps(cvec c);

  /*! reset all FIR filters and counters in cascade
  */
  void reset();
  
  /*! process input samples - [x] for active clock ticks [ce]
  * \param ce - bvec - clock enable vector
  * \param x -  cvec  - input sample vector
  * \return y - cmat  - [cvec|ceo] complex output sample vector|ce output
  */
  cmat process(const bvec &ce, const cvec &x);

};

} // SIM
#endif //CASDEC_XCASDEC_X

