/*xxx
* \brief - SIM::circbuff - derived from itpp::Circular_Buffer<double>
* \author maki
*/


#ifndef SIM_CIRCBUFF_HPP
#define SIM_CIRCBUFF_HPP

#include <itpp/itbase.h>
#include <itpp/itcomm.h>


using namespace itpp;
using namespace std;

namespace SIM
{

/*!
 * \brief circlular buffer \n
 * Core functions SIM::circbuff.process(), SIM::circbuff.generate() \n
 * \details
 * itpp::circular_buffer<double> derived class with clocked interface
 */
class circbuff : public itpp::Circular_Buffer<double>
{
private:
  double y0;

public:

  circbuff()
  {
    y0 = 0.0;
  };

  ~circbuff() 
  { 
  };


  /*! set buffer size
  * \param [in] m - buffer size
  */
  void set_size(int m);
  
  /*! set output value y0
  * \param [in] yout - [double] y0
  */
  void set_output(double yout);

  /*! get buffer size
  * \return - [int] buffer size
  */
  int get_size();

  /*! get output value 
  * \return - [double] y0
  */
  double get_output();

  /*! for active clock ticks [ce] fetch sample and and put back into the buffer \n
  *   if (ce)  {yout = get(); put(yout); \n
  *\param ce - [bvec] clock_enable vector
  *\return y - [vec]
  */
  vec generate(const bvec &ce);

  /*! for active input clock ticks ceio[i,0] put input sample x[i] \n
   *  if (ceio[i,0]) { put(x[i]) } \n
   *  for active output clock ticks ceio[i,1] update yout by fetching one sample \n
   *  if (ceo[i]) { yout = get() } \n
   *\param ceio - [bmat][cei|ceo] input/output clock_enable vector
   *\param x  -   [vec] - input samples 
   *\return y -   [vec] - output samples
  */
  vec process(const bmat &ceio, const vec &x);

};

}
#endif // SIM_CIRCBUFF_HPP
