/*xxx
* \brief - SIM::circbuff_x - - derived from itpp::Circular_Buffer<complex>
* \author maki
*/

#ifndef SIM_CIRCBUFF_X_HPP
#define SIM_CIRCBUFF_X_HPP

#include <itpp/itbase.h>
#include <itpp/itcomm.h>
#include "sim\_sim_extension.hpp"

using namespace itpp;
using namespace std;

namespace SIM
{

/*!
 * \brief complex circular buffer \n
 * Core functions SIM::circbuff_x.process() SIM::circbuff_x.generate() \n
 * \details
 * itpp::circular_buffer<complex> derived class with clocked interface \n
 */
class circbuff_x : public itpp::Circular_Buffer<complexd>
{
private:
  complexd y0;			
public:
  circbuff_x()
  {
    y0 = complexd(0.0, 0.0);
  };
  
  ~circbuff_x() 
  { 
  };

  /*! set buffer size
  * \param [in] m - buffer size
  */
  void set_size(int m);

  /*! set output value y0
  * \param [in] yout - [complex] y0
  */
  void set_output(complexd yout);

  /*! get buffer size
  * \return - [int] buffer size
  */
  int get_size();
  
  /*! get output value
  * \return - [double] y0
  */
  complexd get_output();
  
  /*! for active clock ticks [ce] fetch sample and and put back into the buffer \n
  * if (ce)  {yout = get(); put(yout); \n
  *\param ce - [bvec] clock_enable vector
  *\return y - [cvec]
  */
  cvec generate(const bvec &ce);


  /*! for active input clock ticks [cei] put input samples [x] \n
  *  if (cei[i]) { put(x[i]) } \n
  *  for active output clock ticks [ceo] update y by fetching one sample \n
  *  if (ceo[i]) { yout = get() } \n
  *\param ceio - [bmat][cei|ceo] input/output clock_enable vector
  *\param x  -   [cvec] - input samples
  *\return y -   [cvec] - output samples
  */
  cvec process(const bmat &ceio, const cvec &x);

};


}
#endif // SIM_CIRCBUFF_X_HPP
